/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.common.register.IEFluids;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.StateHolder;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;

public class IEFluidBlock
extends LiquidBlock {
    private static IEFluids.FluidEntry entryStatic;
    private final IEFluids.FluidEntry entry;
    @Nullable
    private MobEffect effect;
    private int duration;
    private int level;

    public IEFluidBlock(IEFluids.FluidEntry entry, BlockBehaviour.Properties props) {
        super(entry.getStillGetter(), (BlockBehaviour.Properties)Util.make((Object)props, $ -> {
            entryStatic = entry;
        }));
        this.entry = entry;
        entryStatic = null;
    }

    protected void createBlockStateDefinition(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        for (Property<?> p : (this.entry == null ? entryStatic : this.entry).properties()) {
            builder.add(new Property[]{p});
        }
    }

    @Nonnull
    public FluidState getFluidState(@Nonnull BlockState state) {
        FluidState baseState = super.getFluidState(state);
        for (Property prop : baseState.getProperties()) {
            if (!state.hasProperty(prop)) continue;
            baseState = IEFluidBlock.withCopiedValue(prop, baseState, state);
        }
        return baseState;
    }

    public static <T extends StateHolder<?, T>, S extends Comparable<S>> T withCopiedValue(Property<S> prop, T oldState, StateHolder<?, ?> copyFrom) {
        return (T)((StateHolder)oldState.setValue(prop, copyFrom.getValue(prop)));
    }

    public void setEffect(@Nonnull MobEffect effect, int duration, int level) {
        this.effect = effect;
        this.duration = duration;
        this.level = level;
    }

    public void entityInside(@Nonnull BlockState state, @Nonnull Level worldIn, @Nonnull BlockPos pos, @Nonnull Entity entityIn) {
        super.entityInside(state, worldIn, pos, entityIn);
        if (this.effect != null && entityIn instanceof LivingEntity) {
            ((LivingEntity)entityIn).addEffect(new MobEffectInstance(this.effect, this.duration, this.level));
        }
    }
}

