/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.fluids;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.items.PotionBucketItem;
import blusunrize.immersiveengineering.common.register.IEFluids;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.common.SoundActions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;

public class PotionFluid
extends Fluid {
    public static FluidStack getFluidStackForType(Potion type, int amount) {
        if (type == Potions.WATER || type == null) {
            return new FluidStack((Fluid)Fluids.WATER, amount);
        }
        FluidStack stack = new FluidStack((Fluid)IEFluids.POTION.get(), amount);
        stack.getOrCreateTag().putString("Potion", BuiltInRegistries.POTION.getKey((Object)type).toString());
        return stack;
    }

    public static Potion getType(FluidStack stack) {
        return PotionFluid.fromTag(stack.getTag());
    }

    public static Potion fromTag(@Nullable CompoundTag tag) {
        if (tag == null || !tag.contains("Potion", 8)) {
            return Potions.WATER;
        }
        ResourceLocation name = ResourceLocation.tryParse((String)tag.getString("Potion"));
        if (name == null) {
            return Potions.WATER;
        }
        Potion result = (Potion)BuiltInRegistries.POTION.get(name);
        return result == Potions.EMPTY ? Potions.WATER : result;
    }

    @Nonnull
    public Item getBucket() {
        return IEItems.Misc.POTION_BUCKET.get();
    }

    protected boolean canBeReplacedWith(@Nonnull FluidState fluidState, @Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull Fluid fluid, @Nonnull Direction direction) {
        return true;
    }

    @Nonnull
    protected Vec3 getFlow(@Nonnull BlockGetter blockReader, @Nonnull BlockPos pos, @Nonnull FluidState fluidState) {
        return Vec3.ZERO;
    }

    public int getTickDelay(LevelReader p_205569_1_) {
        return 0;
    }

    protected float getExplosionResistance() {
        return 0.0f;
    }

    public float getHeight(@Nonnull FluidState p_215662_1_, @Nonnull BlockGetter p_215662_2_, @Nonnull BlockPos p_215662_3_) {
        return 0.0f;
    }

    public float getOwnHeight(@Nonnull FluidState p_223407_1_) {
        return 0.0f;
    }

    @Nonnull
    protected BlockState createLegacyBlock(@Nonnull FluidState state) {
        return Blocks.AIR.defaultBlockState();
    }

    public boolean isSource(@Nonnull FluidState state) {
        return true;
    }

    public int getAmount(@Nonnull FluidState state) {
        return 0;
    }

    @Nonnull
    public VoxelShape getShape(@Nonnull FluidState p_215664_1_, @Nonnull BlockGetter p_215664_2_, @Nonnull BlockPos p_215664_3_) {
        return Shapes.empty();
    }

    @Nonnull
    public FluidType getFluidType() {
        return (FluidType)IEFluids.POTION_TYPE.value();
    }

    public void addInformation(FluidStack fluidStack, Consumer<Component> tooltip) {
        if (fluidStack != null && fluidStack.hasTag()) {
            List effects = PotionUtils.getAllEffects((CompoundTag)fluidStack.getTag());
            if (effects.isEmpty()) {
                tooltip.accept((Component)Component.translatable((String)"effect.none").withStyle(ChatFormatting.GRAY));
            } else {
                for (MobEffectInstance instance : effects) {
                    MutableComponent itextcomponent = Component.translatable((String)instance.getDescriptionId());
                    MobEffect effect = instance.getEffect();
                    if (instance.getAmplifier() > 0) {
                        itextcomponent.append(" ").append((Component)Component.translatable((String)("potion.potency." + instance.getAmplifier())));
                    }
                    if (instance.getDuration() > 20) {
                        itextcomponent.append(" (").append(MobEffectUtil.formatDuration((MobEffectInstance)instance, (float)1.0f, (float)20.0f)).append(")");
                    }
                    tooltip.accept((Component)itextcomponent.withStyle(effect.getCategory().getTooltipFormatting()));
                }
            }
            Potion potionType = PotionUtils.getPotion((CompoundTag)fluidStack.getTag());
            if (potionType != Potions.EMPTY) {
                String modID = BuiltInRegistries.POTION.getKey((Object)potionType).getNamespace();
                tooltip.accept((Component)Component.translatable((String)"desc.immersiveengineering.info.potionMod", (Object[])new Object[]{Utils.getModName(modID)}).withStyle(ChatFormatting.DARK_GRAY));
            }
        }
    }

    public static class PotionFluidType
    extends FluidType {
        private static final ResourceLocation TEXTURE_STILL = ImmersiveEngineering.rl("block/fluid/potion_still");
        private static final ResourceLocation TEXTURE_FLOW = ImmersiveEngineering.rl("block/fluid/potion_flow");

        public PotionFluidType() {
            super(FluidType.Properties.create().sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).density(1300));
        }

        public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
            consumer.accept(new IClientFluidTypeExtensions(){

                public ResourceLocation getStillTexture() {
                    return TEXTURE_STILL;
                }

                public ResourceLocation getFlowingTexture() {
                    return TEXTURE_FLOW;
                }

                public int getTintColor(FluidStack stack) {
                    if (stack.isEmpty() || !stack.hasTag()) {
                        return -16776961;
                    }
                    return 0xFF000000 | PotionUtils.getColor((Collection)PotionUtils.getAllEffects((CompoundTag)stack.getTag()));
                }
            });
        }

        public Component getDescription(FluidStack stack) {
            if (stack == null || !stack.hasTag()) {
                return super.getDescription(stack);
            }
            return Component.translatable((String)PotionUtils.getPotion((CompoundTag)stack.getTag()).getName("item.minecraft.potion.effect."));
        }

        public ItemStack getBucket(FluidStack stack) {
            return PotionBucketItem.forPotion(PotionFluid.getType(stack));
        }
    }
}

