/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.wooden.WoodenCrateBlockEntity;
import blusunrize.immersiveengineering.common.gui.IScreenMessageReceive;
import com.google.common.base.Preconditions;
import invtweaks.api.container.ChestContainer;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

@ChestContainer
public class CrateMenu
extends AbstractContainerMenu
implements IScreenMessageReceive {
    private final Container container;

    public CrateMenu(MenuType<?> type, int id, Inventory inventoryPlayer, Container container) {
        super(type, id);
        int i;
        Preconditions.checkArgument((container.getContainerSize() == 27 ? 1 : 0) != 0);
        this.container = container;
        for (i = 0; i < container.getContainerSize(); ++i) {
            this.addSlot(new Slot(container, i, 8 + i % 9 * 18, 18 + i / 9 * 18){

                public boolean mayPlace(ItemStack stack) {
                    return IEApi.isAllowedInCrate(stack);
                }
            });
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 87 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 145));
        }
    }

    public CrateMenu(MenuType<?> type, int id, Inventory inventoryPlayer) {
        this(type, id, inventoryPlayer, (Container)new SimpleContainer(27));
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        Container container = this.container;
        if (container instanceof WoodenCrateBlockEntity) {
            WoodenCrateBlockEntity crate = (WoodenCrateBlockEntity)container;
            crate.setCustomName((Component)Component.literal((String)nbt.getString("name")));
            crate.doGraphicalUpdates();
        }
    }

    public boolean stillValid(@Nonnull Player pPlayer) {
        return this.container.stillValid(pPlayer);
    }

    public ItemStack quickMoveStack(Player pPlayer, int pIndex) {
        ItemStack stackInSlot = ItemStack.EMPTY;
        Slot slot = (Slot)this.slots.get(pIndex);
        if (slot != null && slot.hasItem()) {
            ItemStack itemInSlot = slot.getItem();
            stackInSlot = itemInSlot.copy();
            if (pIndex < 27 ? !this.moveItemStackTo(itemInSlot, 27, this.slots.size(), true) : !this.moveItemStackTo(itemInSlot, 0, 27, false)) {
                return ItemStack.EMPTY;
            }
            slot.setChanged();
        }
        return stackInSlot;
    }
}

