/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.api.multiblocks.blocks.logic.IMultiblockState;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.IScreenMessageReceive;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.network.MessageContainerData;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.PlayerContainerEvent;
import net.neoforged.neoforge.items.ItemHandlerHelper;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public abstract class IEContainerMenu
extends AbstractContainerMenu
implements IScreenMessageReceive {
    private final List<GenericContainerData<?>> genericData = new ArrayList();
    private final List<ServerPlayer> usingPlayers = new ArrayList<ServerPlayer>();
    private final Runnable setChanged;
    private final Predicate<Player> isValid;
    public int ownSlotCount;

    protected IEContainerMenu(MenuContext ctx) {
        super(ctx.type, ctx.id);
        this.setChanged = ctx.setChanged;
        this.isValid = ctx.isValid;
    }

    public void addGenericData(GenericContainerData<?> newData) {
        this.genericData.add(newData);
    }

    public void broadcastChanges() {
        super.broadcastChanges();
        ArrayList toSync = new ArrayList();
        for (int i = 0; i < this.genericData.size(); ++i) {
            GenericContainerData<?> data = this.genericData.get(i);
            if (!data.needsUpdate()) continue;
            toSync.add(Pair.of((Object)i, data.dataPair()));
        }
        if (!toSync.isEmpty()) {
            for (ServerPlayer player : this.usingPlayers) {
                player.connection.send((CustomPacketPayload)new MessageContainerData(toSync));
            }
        }
    }

    public void receiveSync(List<Pair<Integer, GenericDataSerializers.DataPair<?>>> synced) {
        for (Pair<Integer, GenericDataSerializers.DataPair<?>> syncElement : synced) {
            this.genericData.get((Integer)syncElement.getFirst()).processSync(((GenericDataSerializers.DataPair)syncElement.getSecond()).data());
        }
    }

    public void clicked(int id, int dragType, ClickType clickType, Player player) {
        Slot slot;
        Slot slot2 = slot = id < 0 ? null : (Slot)this.slots.get(id);
        if (!(slot instanceof IESlot.ItemHandlerGhost)) {
            super.clicked(id, dragType, clickType, player);
            return;
        }
        ItemStack stackSlot = slot.getItem();
        if (dragType == 2) {
            slot.set(ItemStack.EMPTY);
        } else if (dragType == 0 || dragType == 1) {
            ItemStack stackHeld = this.getCarried();
            int amount = Math.min(slot.getMaxStackSize(), stackHeld.getCount());
            if (dragType == 1) {
                amount = 1;
            }
            if (stackSlot.isEmpty()) {
                if (!stackHeld.isEmpty() && slot.mayPlace(stackHeld)) {
                    slot.set(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
                }
            } else if (stackHeld.isEmpty()) {
                slot.set(ItemStack.EMPTY);
            } else if (slot.mayPlace(stackHeld)) {
                if (ItemStack.isSameItem((ItemStack)stackSlot, (ItemStack)stackHeld)) {
                    stackSlot.grow(amount);
                } else {
                    slot.set(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
                }
            }
            if (stackSlot.getCount() > slot.getMaxStackSize()) {
                stackSlot.setCount(slot.getMaxStackSize());
            }
        } else if (dragType == 5) {
            ItemStack stackHeld = this.getCarried();
            int amount = Math.min(slot.getMaxStackSize(), stackHeld.getCount());
            if (!slot.hasItem()) {
                slot.set(ItemHandlerHelper.copyStackWithSize((ItemStack)stackHeld, (int)amount));
            }
        }
    }

    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack itemstack = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.slots.get(slot);
        if (slotObject != null && slotObject.hasItem()) {
            ItemStack itemstack1 = slotObject.getItem();
            itemstack = itemstack1.copy();
            if (slot < this.ownSlotCount ? !this.moveItemStackTo(itemstack1, this.ownSlotCount, this.slots.size(), true) : !this.moveItemStackToWithMayPlace(itemstack1, 0, this.ownSlotCount)) {
                return ItemStack.EMPTY;
            }
            if (itemstack1.isEmpty()) {
                slotObject.set(ItemStack.EMPTY);
            } else {
                slotObject.setChanged();
            }
        }
        return itemstack;
    }

    protected boolean moveItemStackToWithMayPlace(ItemStack pStack, int pStartIndex, int pEndIndex) {
        return IEContainerMenu.moveItemStackToWithMayPlace((List<Slot>)this.slots, (x$0, x$1, x$2, x$3) -> this.moveItemStackTo(x$0, x$1, x$2, x$3), pStack, pStartIndex, pEndIndex);
    }

    public static boolean moveItemStackToWithMayPlace(List<Slot> slots, MoveItemsFunc move, ItemStack pStack, int pStartIndex, int pEndIndex) {
        boolean inAllowedRange = true;
        int allowedStart = pStartIndex;
        for (int i = pStartIndex; i < pEndIndex; ++i) {
            boolean mayplace = slots.get(i).mayPlace(pStack);
            if (inAllowedRange && !mayplace) {
                if (move.moveItemStackTo(pStack, allowedStart, i, false)) {
                    return true;
                }
                inAllowedRange = false;
                continue;
            }
            if (inAllowedRange || !mayplace) continue;
            allowedStart = i;
            inAllowedRange = true;
        }
        return inAllowedRange && move.moveItemStackTo(pStack, allowedStart, pEndIndex, false);
    }

    public void removed(@Nonnull Player player) {
        super.removed(player);
        this.setChanged.run();
    }

    public boolean stillValid(@Nonnull Player pPlayer) {
        return this.isValid.test(pPlayer);
    }

    @SubscribeEvent
    public static void onContainerOpened(PlayerContainerEvent.Open ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (abstractContainerMenu instanceof IEContainerMenu) {
            IEContainerMenu ieContainer = (IEContainerMenu)abstractContainerMenu;
            abstractContainerMenu = ev.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                ieContainer.usingPlayers.add(serverPlayer);
                ArrayList list = new ArrayList();
                for (int i = 0; i < ieContainer.genericData.size(); ++i) {
                    list.add(Pair.of((Object)i, ieContainer.genericData.get(i).dataPair()));
                }
                serverPlayer.connection.send((CustomPacketPayload)new MessageContainerData(list));
            }
        }
    }

    @SubscribeEvent
    public static void onContainerClosed(PlayerContainerEvent.Close ev) {
        AbstractContainerMenu abstractContainerMenu = ev.getContainer();
        if (abstractContainerMenu instanceof IEContainerMenu) {
            IEContainerMenu ieContainer = (IEContainerMenu)abstractContainerMenu;
            abstractContainerMenu = ev.getEntity();
            if (abstractContainerMenu instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)abstractContainerMenu;
                ieContainer.usingPlayers.remove(serverPlayer);
            }
        }
    }

    public static MenuContext multiblockCtx(MenuType<?> pMenuType, int pContainerId, MultiblockMenuContext<?> ctx) {
        return new MenuContext(pMenuType, pContainerId, ctx.mbContext()::markMasterDirty, p -> {
            if (!ctx.mbContext().isValid().getAsBoolean()) {
                return false;
            }
            return p.distanceToSqr(Vec3.atCenterOf((Vec3i)ctx.clickedPos)) <= 64.0;
        });
    }

    public static MenuContext blockCtx(MenuType<?> pMenuType, int pContainerId, BlockEntity be) {
        return new MenuContext(pMenuType, pContainerId, () -> {
            be.setChanged();
            if (be instanceof IEBaseBlockEntity) {
                IEBaseBlockEntity ieBE = (IEBaseBlockEntity)be;
                ieBE.markContainingBlockForUpdate(null);
            }
        }, p -> {
            BlockPos pos = be.getBlockPos();
            Level level = be.getLevel();
            if (level == null || level.getBlockEntity(pos) != be) {
                return false;
            }
            return !(p.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) > 64.0);
        });
    }

    public static MenuContext itemCtx(MenuType<?> pMenuType, int pContainerId, Inventory playerInv, EquipmentSlot slot, ItemStack stack) {
        return new MenuContext(pMenuType, pContainerId, () -> {}, p -> {
            if (p != playerInv.player) {
                return false;
            }
            return ItemStack.isSameItem((ItemStack)p.getItemBySlot(slot), (ItemStack)stack);
        });
    }

    public static MenuContext clientCtx(MenuType<?> pMenuType, int pContainerId) {
        return new MenuContext(pMenuType, pContainerId, () -> {}, $ -> true);
    }

    protected record MenuContext(MenuType<?> type, int id, Runnable setChanged, Predicate<Player> isValid) {
    }

    public static interface MoveItemsFunc {
        public boolean moveItemStackTo(ItemStack var1, int var2, int var3, boolean var4);
    }

    public record MultiblockMenuContext<S extends IMultiblockState>(IMultiblockContext<S> mbContext, BlockPos clickedPos) {
    }
}

