/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.util.Utils;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class ItemContainer
extends AbstractContainerMenu
implements Supplier<Level> {
    protected final Inventory inventoryPlayer;
    protected final Level world;
    protected int blockedSlot;
    protected final EquipmentSlot equipmentSlot;
    protected final ItemStack heldItem;
    protected final Player player;
    public int internalSlots;

    public ItemContainer(MenuType<?> type, int id, Inventory inventoryPlayer, Level world, EquipmentSlot entityEquipmentSlot, ItemStack heldItem) {
        super(type, id);
        this.inventoryPlayer = inventoryPlayer;
        this.world = world;
        this.player = inventoryPlayer.player;
        this.equipmentSlot = entityEquipmentSlot;
        this.heldItem = heldItem.copy();
        this.updateSlots();
    }

    protected void updateSlots() {
        this.internalSlots = this.addSlots();
        this.blockedSlot = this.inventoryPlayer.selected + 27 + this.internalSlots;
    }

    abstract int addSlots();

    public EquipmentSlot getEquipmentSlot() {
        return this.equipmentSlot;
    }

    @Nonnull
    public ItemStack quickMoveStack(Player par1EntityPlayer, int slot) {
        ItemStack oldStackInSlot = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.slots.get(slot);
        if (slotObject != null && slotObject.hasItem()) {
            ItemStack stackInSlot = slotObject.getItem();
            oldStackInSlot = stackInSlot.copy();
            if (slot < this.internalSlots) {
                if (!this.moveItemStackTo(stackInSlot, this.internalSlots, this.internalSlots + 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (this.allowShiftclicking() && !stackInSlot.isEmpty()) {
                boolean b = true;
                for (int i = 0; i < this.internalSlots; ++i) {
                    Slot s = (Slot)this.slots.get(i);
                    if (s == null || !s.mayPlace(stackInSlot) || !s.getItem().isEmpty() && (!ItemStack.isSameItem((ItemStack)stackInSlot, (ItemStack)s.getItem()) || !Utils.compareItemNBT(stackInSlot, s.getItem()))) continue;
                    int space = Math.min(s.getMaxStackSize(stackInSlot), stackInSlot.getMaxStackSize());
                    if (!s.getItem().isEmpty()) {
                        space -= s.getItem().getCount();
                    }
                    if (space <= 0) continue;
                    ItemStack insert = stackInSlot;
                    if (space < stackInSlot.getCount()) {
                        insert = stackInSlot.split(space);
                    }
                    if (!this.moveItemStackTo(insert, i, i + 1, true)) continue;
                    b = false;
                }
                if (b) {
                    return ItemStack.EMPTY;
                }
            }
            if (stackInSlot.getCount() == 0) {
                slotObject.set(ItemStack.EMPTY);
            } else {
                slotObject.setChanged();
            }
            slotObject.container.setChanged();
            if (stackInSlot.getCount() == oldStackInSlot.getCount()) {
                return ItemStack.EMPTY;
            }
            slotObject.onTake(this.player, oldStackInSlot);
            this.broadcastChanges();
        }
        return oldStackInSlot;
    }

    protected boolean allowShiftclicking() {
        return true;
    }

    public boolean stillValid(@Nonnull Player entityplayer) {
        return ItemStack.isSameItem((ItemStack)this.player.getItemBySlot(this.equipmentSlot), (ItemStack)this.heldItem);
    }

    public void clicked(int par1, int par2, ClickType par3, Player par4EntityPlayer) {
        if (par1 == this.blockedSlot || par3 == ClickType.SWAP && par2 == par4EntityPlayer.getInventory().selected) {
            return;
        }
        super.clicked(par1, par2, par3, par4EntityPlayer);
        this.broadcastChanges();
    }

    @Override
    public Level get() {
        return this.world;
    }
}

