/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.ItemContainer;
import blusunrize.immersiveengineering.mixin.accessors.ContainerAccess;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class MaintenanceKitContainer
extends ItemContainer {
    private final Container inv = new SimpleContainer(new ItemStack[]{ItemStack.EMPTY});
    private final ItemStackHandler clientInventory = new ItemStackHandler(37);
    private boolean wasUsed = false;

    public MaintenanceKitContainer(MenuType<?> type, int id, Inventory inventoryPlayer, Level world, EquipmentSlot slot, ItemStack item) {
        super(type, id, inventoryPlayer, world, slot, item);
        this.updateSlots();
    }

    private void bindPlayerInv(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 85 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 143));
        }
    }

    @Override
    public int addSlots() {
        if (this.inv == null) {
            return 0;
        }
        this.slots.clear();
        ((ContainerAccess)((Object)this)).getLastSlots().clear();
        this.addSlot(new IESlot.Maintenance(this, this.inv, 0, 28, 10));
        int slotCount = 1;
        ItemStack tool = this.getSlot(0).getItem();
        Item item = tool.getItem();
        if (item instanceof IUpgradeableTool) {
            IUpgradeableTool upgradeableTool = (IUpgradeableTool)item;
            this.wasUsed = true;
            IItemHandler toolInv = Objects.requireNonNull((IItemHandler)tool.getCapability(Capabilities.ItemHandler.ITEM));
            Slot[] slots = upgradeableTool.getWorkbenchSlots(this, tool, this.world, () -> this.player, (IItemHandler)(this.world.isClientSide ? this.clientInventory : toolInv));
            if (slots != null) {
                for (Slot s : slots) {
                    this.addSlot(s);
                    ++slotCount;
                }
            }
        }
        while (slotCount < 36) {
            this.addSlot(new IESlot.AlwaysEmptySlot(this));
            ++slotCount;
        }
        this.bindPlayerInv(this.inventoryPlayer);
        ImmersiveEngineering.proxy.reInitGui();
        return slotCount;
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack stack = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.slots.get(slot);
        if (slotObject != null && slotObject.hasItem()) {
            ItemStack stackInSlot = slotObject.getItem();
            stack = stackInSlot.copy();
            if (slot < this.internalSlots) {
                if (!this.moveItemStackTo(stackInSlot, this.internalSlots, this.internalSlots + 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!stackInSlot.isEmpty()) {
                if (stackInSlot.getItem() instanceof IUpgradeableTool && ((IUpgradeableTool)stackInSlot.getItem()).canModify(stackInSlot)) {
                    if (!this.moveItemStackTo(stackInSlot, 0, 1, true)) {
                        return ItemStack.EMPTY;
                    }
                } else if (stackInSlot.getItem() instanceof IConfigurableTool && ((IConfigurableTool)stackInSlot.getItem()).canConfigure(stackInSlot)) {
                    if (!this.moveItemStackTo(stackInSlot, 0, 1, true)) {
                        return ItemStack.EMPTY;
                    }
                } else if (this.internalSlots > 1) {
                    boolean b = true;
                    for (int i = 1; i < this.internalSlots; ++i) {
                        Slot s = (Slot)this.slots.get(i);
                        if (s == null || !s.mayPlace(stackInSlot) || !this.moveItemStackTo(stackInSlot, i, i + 1, true)) continue;
                        b = false;
                        break;
                    }
                    if (b) {
                        return ItemStack.EMPTY;
                    }
                }
            }
            if (stackInSlot.getCount() == 0) {
                slotObject.set(ItemStack.EMPTY);
            } else {
                slotObject.setChanged();
            }
            if (stackInSlot.getCount() == stack.getCount()) {
                return ItemStack.EMPTY;
            }
            slotObject.onTake(player, stack);
        }
        return stack;
    }

    public void removed(Player par1EntityPlayer) {
        if (this.wasUsed) {
            this.heldItem.hurtAndBreak(1, (LivingEntity)this.player, player -> {});
            this.player.setItemSlot(this.equipmentSlot, this.heldItem);
        }
        super.removed(par1EntityPlayer);
        this.clearContainer(par1EntityPlayer, this.inv);
    }
}

