/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.gui.BlueprintInventory;
import blusunrize.immersiveengineering.common.gui.IEBaseContainerOld;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.ShaderInventory;
import blusunrize.immersiveengineering.common.items.EngineersBlueprintItem;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import blusunrize.immersiveengineering.mixin.accessors.ContainerAccess;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class ModWorkbenchContainer
extends IEBaseContainerOld<ModWorkbenchBlockEntity> {
    public static final int MAX_NUM_DYNAMIC_SLOTS = 36;
    public static final int OUTPUTS_PER_PAGE = 9;
    private final Level world;
    public Inventory inventoryPlayer;
    private BlueprintInventory inventoryBPoutput;
    public ShaderInventory shaderInv;
    private final ItemStackHandler clientInventory = new ItemStackHandler(37);
    private int pages = 0;
    private int currentPage = 0;

    public ModWorkbenchContainer(MenuType<?> type, int id, Inventory inventoryPlayer, ModWorkbenchBlockEntity tile) {
        super(type, tile, id);
        this.world = tile.getLevelNonnull();
        this.inventoryPlayer = inventoryPlayer;
        this.rebindSlots();
    }

    private void bindPlayerInv(Inventory inventoryPlayer) {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 87 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 145));
        }
    }

    public void rebindSlots() {
        this.slots.clear();
        ((ContainerAccess)((Object)this)).getLastSlots().clear();
        ((ContainerAccess)((Object)this)).getRemoteSlots().clear();
        this.addSlot(new IESlot.ModWorkbench(this, this.inv, 0, 24, 22, 1));
        this.ownSlotCount = 1;
        ItemStack tool = this.getSlot(0).getItem();
        Item item = tool.getItem();
        if (item instanceof IUpgradeableTool) {
            CapabilityShader.ShaderWrapper wrapper;
            Slot[] slots;
            IUpgradeableTool upgradeableTool = (IUpgradeableTool)item;
            IItemHandler toolInv = Objects.requireNonNull((IItemHandler)tool.getCapability(Capabilities.ItemHandler.ITEM));
            if (toolInv instanceof IEItemStackHandler) {
                IEItemStackHandler ieInv = (IEItemStackHandler)toolInv;
                ieInv.setTile(this.tile);
            }
            if ((slots = upgradeableTool.getWorkbenchSlots(this, tool, this.world, () -> this.inventoryPlayer.player, (IItemHandler)(this.world.isClientSide ? this.clientInventory : toolInv))) != null) {
                for (Slot s : slots) {
                    this.addSlot(s);
                    ++this.ownSlotCount;
                }
            }
            if ((wrapper = (CapabilityShader.ShaderWrapper)tool.getCapability(CapabilityShader.ITEM)) != null) {
                this.shaderInv = new ShaderInventory(this, wrapper);
                this.addSlot(new IESlot.Shader(this, this.shaderInv, 0, 130, 32, tool));
                ++this.ownSlotCount;
                this.shaderInv.shader = wrapper.getShaderItem();
            }
        } else if (!(tool.getItem() instanceof IConfigurableTool)) {
            boolean blueprint = false;
            if (tool.getItem() instanceof EngineersBlueprintItem) {
                blueprint = true;
                List<RecipeHolder<BlueprintCraftingRecipe>> recipes = EngineersBlueprintItem.getRecipes(this.world, tool);
                this.inventoryBPoutput = new BlueprintInventory(this, recipes);
                this.currentPage = 0;
                this.pages = recipes.size() / 9 + 1;
                for (int i = 0; i < recipes.size(); ++i) {
                    int y = 21 + i % 9 / 3 * 18;
                    this.addSlot(new IESlot.BlueprintOutput(this, this.inventoryBPoutput, this.inv, i, 118 + i % 3 * 18, y, (BlueprintCraftingRecipe)recipes.get(i).value()));
                    ++this.ownSlotCount;
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (blueprint) {
                    this.addSlot(new IESlot.BlueprintInput(this, this.inv, this.inventoryBPoutput, i + 1, i % 2 == 0 ? 74 : 92, 21 + i / 2 * 18));
                } else {
                    this.addSlot(new Slot(this.inv, i + 1, i % 2 == 0 ? 74 : 92, 21 + i / 2 * 18));
                }
                ++this.ownSlotCount;
            }
            if (this.inventoryBPoutput != null) {
                this.inventoryBPoutput.updateOutputs(this.inv);
            }
        }
        while (this.ownSlotCount < 36) {
            this.addSlot(new IESlot.AlwaysEmptySlot(this));
            ++this.ownSlotCount;
        }
        this.bindPlayerInv(this.inventoryPlayer);
        ImmersiveEngineering.proxy.reInitGui();
    }

    public boolean isOutputSlotOnPage(IESlot.BlueprintOutput slot) {
        return slot.getSlotIndex() >= this.currentPage * 9 && slot.getSlotIndex() < (this.currentPage + 1) * 9;
    }

    public boolean clickMenuButton(Player player, int buttonId) {
        this.currentPage = buttonId == 1 ? Math.floorMod(this.currentPage - 1, this.pages) : Math.floorMod(this.currentPage + 1, this.pages);
        return true;
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        ItemStack resultStack = ItemStack.EMPTY;
        Slot slotObject = (Slot)this.slots.get(slot);
        if (slotObject != null && slotObject.hasItem()) {
            ItemStack stackInSlot = slotObject.getItem();
            resultStack = stackInSlot.copy();
            if (slot < this.ownSlotCount) {
                if (!this.moveItemStackTo(stackInSlot, this.ownSlotCount, this.ownSlotCount + 36, true)) {
                    return ItemStack.EMPTY;
                }
            } else if (!stackInSlot.isEmpty()) {
                IConfigurableTool cTool;
                IUpgradeableTool uTool;
                Item item;
                boolean singleSlot;
                boolean bl = singleSlot = this.ownSlotCount == 1;
                if ((stackInSlot.getItem() instanceof EngineersBlueprintItem || (item = stackInSlot.getItem()) instanceof IUpgradeableTool && (uTool = (IUpgradeableTool)item).canModify(stackInSlot) || (item = stackInSlot.getItem()) instanceof IConfigurableTool && (cTool = (IConfigurableTool)item).canConfigure(stackInSlot)) && !this.moveItemStackTo(stackInSlot, 0, 1, false) && singleSlot) {
                    return ItemStack.EMPTY;
                }
                if (!singleSlot && !this.moveItemStackTo(stackInSlot, 1, this.ownSlotCount, false)) {
                    return ItemStack.EMPTY;
                }
            }
            slotObject.setChanged();
            if (stackInSlot.getCount() == resultStack.getCount()) {
                resultStack = ItemStack.EMPTY;
            }
            slotObject.onTake(player, resultStack);
            if (slotObject.hasItem()) {
                player.drop(slotObject.getItem(), false);
            }
        }
        return resultStack;
    }

    protected boolean moveItemStackTo(ItemStack stack, int startIndex, int endIndex, boolean reverseDirection) {
        return IEContainerMenu.moveItemStackToWithMayPlace((List<Slot>)this.slots, (x$0, x$1, x$2, x$3) -> super.moveItemStackTo(x$0, x$1, x$2, x$3), stack, startIndex, endIndex);
    }

    @Override
    public void clicked(int id, int dragType, ClickType clickType, Player player) {
        super.clicked(id, dragType, clickType, player);
        ((ModWorkbenchBlockEntity)this.tile).markContainingBlockForUpdate(null);
        if (!this.world.isClientSide) {
            this.broadcastChanges();
        }
    }

    public boolean canTakeItemForPickAll(ItemStack pStack, Slot pSlot) {
        return pSlot.container != this.inventoryBPoutput && super.canTakeItemForPickAll(pStack, pSlot);
    }
}

