/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.api.energy.MutableEnergyStorage;
import blusunrize.immersiveengineering.api.multiblocks.blocks.env.IMultiblockContext;
import blusunrize.immersiveengineering.common.blocks.multiblocks.logic.RadioTowerLogic;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.Comparator;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class RadioTowerMenu
extends IEContainerMenu {
    public final IEnergyStorage energy;
    public final GetterAndSetter<Integer> frequency;
    public final GetterAndSetter<int[]> savedFrequencies;
    public final GetterAndSetter<Integer> range;
    public final GetterAndSetter<NearbyComponents> otherComponents;
    public final Runnable markDirty;

    public static RadioTowerMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, IEContainerMenu.MultiblockMenuContext<RadioTowerLogic.State> ctx) {
        RadioTowerLogic.State state = ctx.mbContext().getState();
        return new RadioTowerMenu(RadioTowerMenu.multiblockCtx(type, id, ctx), invPlayer, state.energy, new GetterAndSetter<Integer>(state::getFrequency, state::setFrequency), new GetterAndSetter<int[]>(state::getSavedFrequencies, state::setSavedFrequencies), GetterAndSetter.getterOnly(state::getChunkRange), GetterAndSetter.getterOnly(() -> NearbyComponents.fromCtx(ctx.mbContext())), state::markSendAndReceiveDirty);
    }

    public static RadioTowerMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        return new RadioTowerMenu(RadioTowerMenu.clientCtx(type, id), invPlayer, new MutableEnergyStorage(64000), GetterAndSetter.standalone(0), GetterAndSetter.standalone(new int[0]), GetterAndSetter.standalone(0), GetterAndSetter.standalone(new NearbyComponents(List.of())), () -> {});
    }

    private RadioTowerMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, MutableEnergyStorage energy, GetterAndSetter<Integer> frequency, GetterAndSetter<int[]> savedFrequencies, GetterAndSetter<Integer> range, GetterAndSetter<NearbyComponents> otherComponents, Runnable markDirty) {
        super(ctx);
        this.energy = energy;
        this.frequency = frequency;
        this.savedFrequencies = savedFrequencies;
        this.range = range;
        this.otherComponents = otherComponents;
        this.markDirty = markDirty;
        this.addGenericData(GenericContainerData.energy(energy));
        this.addGenericData(new GenericContainerData<Integer>(GenericDataSerializers.INT32, frequency));
        this.addGenericData(new GenericContainerData<int[]>(GenericDataSerializers.INT_ARRAY, savedFrequencies));
        this.addGenericData(new GenericContainerData<Integer>(GenericDataSerializers.INT32, range));
        this.addGenericData(new GenericContainerData<NearbyComponents>(GenericDataSerializers.RADIO_TOWER_NEARBY, otherComponents));
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag nbt) {
        if (nbt.contains("frequency", 3)) {
            this.frequency.set(nbt.getInt("frequency"));
        }
        if (nbt.contains("savedFrequencies", 11)) {
            this.savedFrequencies.set(nbt.getIntArray("savedFrequencies"));
        }
        this.markDirty.run();
    }

    public record NearbyComponents(List<Vec3> positions) {
        public static NearbyComponents fromCtx(IMultiblockContext<RadioTowerLogic.State> ctx) {
            RadioTowerLogic.State state = ctx.getState();
            List<Vec3> list = state.getRelativeComponentsInRange(ctx);
            double distMod = 1.0 / list.stream().max(Comparator.comparingDouble(Vec3::lengthSqr)).orElse(Vec3.ZERO).length();
            return new NearbyComponents(list.stream().map(vec3 -> vec3.scale(distMod)).toList());
        }

        public static NearbyComponents from(FriendlyByteBuf buffer) {
            return new NearbyComponents(buffer.readList(FriendlyByteBuf::readVec3));
        }

        public static void writeTo(FriendlyByteBuf out, NearbyComponents nearby) {
            out.writeCollection(nearby.positions(), FriendlyByteBuf::writeVec3);
        }
    }
}

