/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui;

import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.gui.sync.GenericContainerData;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.gui.sync.GetterAndSetter;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.ItemStackHandler;

public class SorterMenu
extends IEContainerMenu {
    public final List<GetterAndSetter<Integer>> filterMasks;

    public static SorterMenu makeServer(MenuType<?> type, int id, Inventory invPlayer, SorterBlockEntity be) {
        List<GetterAndSetter<Integer>> filters = IntStream.range(0, 6).mapToObj(i -> new GetterAndSetter<Integer>(() -> be.sideFilter[i], f -> {
            be.sideFilter[i] = f;
        })).toList();
        return new SorterMenu(SorterMenu.blockCtx(type, id, be), invPlayer, (IItemHandler)be.filter, filters);
    }

    public static SorterMenu makeClient(MenuType<?> type, int id, Inventory invPlayer) {
        List<GetterAndSetter<Integer>> filters = IntStream.range(0, 6).mapToObj(i -> GetterAndSetter.standalone(0)).toList();
        return new SorterMenu(SorterMenu.clientCtx(type, id), invPlayer, (IItemHandler)new ItemStackHandler(48), filters);
    }

    private SorterMenu(IEContainerMenu.MenuContext ctx, Inventory inventoryPlayer, IItemHandler filter, List<GetterAndSetter<Integer>> filterMasks) {
        super(ctx);
        int i;
        this.filterMasks = filterMasks;
        for (int side = 0; side < 6; ++side) {
            for (int i2 = 0; i2 < 8; ++i2) {
                int x = 4 + side / 2 * 58 + (i2 < 3 ? i2 * 18 : (i2 > 4 ? (i2 - 5) * 18 : (i2 == 3 ? 0 : 36)));
                int y = 22 + side % 2 * 76 + (i2 < 3 ? 0 : (i2 > 4 ? 36 : 18));
                int id = side * 8 + i2;
                this.addSlot((Slot)new IESlot.ItemHandlerGhost(filter, id, x, y));
            }
        }
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.addSlot(new Slot((Container)inventoryPlayer, j + i * 9 + 9, 8 + j * 18, 163 + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.addSlot(new Slot((Container)inventoryPlayer, i, 8 + i * 18, 221));
        }
        for (GetterAndSetter<Integer> mask : filterMasks) {
            this.addGenericData(new GenericContainerData<Integer>(GenericDataSerializers.INT32, mask));
        }
    }

    @Override
    @Nonnull
    public ItemStack quickMoveStack(Player player, int slot) {
        return ItemStack.EMPTY;
    }

    @Override
    public void receiveMessageFromScreen(CompoundTag message) {
        if (message.contains("sideConfigVal", 3)) {
            this.filterMasks.get(message.getInt("sideConfigId")).set(message.getInt("sideConfigVal"));
        }
    }
}

