/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui.sync;

import blusunrize.immersiveengineering.common.gui.ArcFurnaceMenu;
import blusunrize.immersiveengineering.common.gui.MixerMenu;
import blusunrize.immersiveengineering.common.gui.RadioTowerMenu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.common.extensions.IFriendlyByteBufExtension;
import net.neoforged.neoforge.fluids.FluidStack;

public class GenericDataSerializers {
    private static final List<DataSerializer<?>> SERIALIZERS = new ArrayList();
    public static final DataSerializer<Integer> INT32 = GenericDataSerializers.register(FriendlyByteBuf::readVarInt, FriendlyByteBuf::writeVarInt);
    public static final DataSerializer<FluidStack> FLUID_STACK = GenericDataSerializers.register(IFriendlyByteBufExtension::readFluidStack, IFriendlyByteBufExtension::writeFluidStack, FluidStack::copy, FluidStack::isFluidStackIdentical);
    public static final DataSerializer<Boolean> BOOLEAN = GenericDataSerializers.register(FriendlyByteBuf::readBoolean, FriendlyByteBuf::writeBoolean);
    public static final DataSerializer<Float> FLOAT = GenericDataSerializers.register(FriendlyByteBuf::readFloat, FriendlyByteBuf::writeFloat);
    public static final DataSerializer<List<ArcFurnaceMenu.ProcessSlot>> ARC_PROCESS_SLOTS = GenericDataSerializers.register(fbb -> fbb.readList(ArcFurnaceMenu.ProcessSlot::from), (fbb, l) -> fbb.writeCollection((Collection)l, ArcFurnaceMenu.ProcessSlot::writeTo));
    public static final DataSerializer<ItemStack> ITEM_STACK = GenericDataSerializers.register(FriendlyByteBuf::readItem, FriendlyByteBuf::writeItem, ItemStack::copy, ItemStack::matches);
    public static final DataSerializer<byte[]> BYTE_ARRAY = GenericDataSerializers.register(FriendlyByteBuf::readByteArray, FriendlyByteBuf::writeByteArray, arr -> Arrays.copyOf(arr, ((byte[])arr).length), Arrays::equals);
    public static final DataSerializer<int[]> INT_ARRAY = GenericDataSerializers.register(FriendlyByteBuf::readVarIntArray, FriendlyByteBuf::writeVarIntArray, arr -> Arrays.copyOf(arr, ((int[])arr).length), Arrays::equals);
    public static final DataSerializer<List<FluidStack>> FLUID_STACKS = GenericDataSerializers.register(fbb -> fbb.readList(IFriendlyByteBufExtension::readFluidStack), (fbb, stacks) -> fbb.writeCollection((Collection)stacks, IFriendlyByteBufExtension::writeFluidStack), l -> l.stream().map(FluidStack::copy).toList(), (l1, l2) -> {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (((FluidStack)l1.get(i)).isFluidStackIdentical((FluidStack)l2.get(i))) continue;
            return false;
        }
        return true;
    });
    public static final DataSerializer<List<MixerMenu.SlotProgress>> MIXER_SLOTS = GenericDataSerializers.register(fbb -> fbb.readList(MixerMenu.SlotProgress::new), (fbb, list) -> fbb.writeCollection((Collection)list, MixerMenu.SlotProgress::write));
    public static final DataSerializer<List<String>> STRINGS = GenericDataSerializers.register(fbb -> fbb.readList(FriendlyByteBuf::readUtf), (fbb, list) -> fbb.writeCollection((Collection)list, FriendlyByteBuf::writeUtf), ArrayList::new, List::equals);
    public static final DataSerializer<RadioTowerMenu.NearbyComponents> RADIO_TOWER_NEARBY = GenericDataSerializers.register(RadioTowerMenu.NearbyComponents::from, RadioTowerMenu.NearbyComponents::writeTo);

    private static <T> DataSerializer<T> register(Function<FriendlyByteBuf, T> read, BiConsumer<FriendlyByteBuf, T> write) {
        return GenericDataSerializers.register(read, write, t -> t, Objects::equals);
    }

    private static <T> DataSerializer<T> register(Function<FriendlyByteBuf, T> read, BiConsumer<FriendlyByteBuf, T> write, UnaryOperator<T> copy, BiPredicate<T, T> equals) {
        DataSerializer<T> serializer = new DataSerializer<T>(read, write, copy, equals, SERIALIZERS.size());
        SERIALIZERS.add(serializer);
        return serializer;
    }

    public static DataPair<?> read(FriendlyByteBuf buffer) {
        DataSerializer<?> serializer = SERIALIZERS.get(buffer.readVarInt());
        return serializer.read(buffer);
    }

    public record DataSerializer<T>(Function<FriendlyByteBuf, T> read, BiConsumer<FriendlyByteBuf, T> write, UnaryOperator<T> copy, BiPredicate<T, T> equals, int id) {
        public DataPair<T> read(FriendlyByteBuf from) {
            return new DataPair<T>(this, this.read().apply(from));
        }
    }

    public record DataPair<T>(DataSerializer<T> serializer, T data) {
        public void write(FriendlyByteBuf to) {
            to.writeVarInt(this.serializer.id());
            this.serializer.write().accept(to, (FriendlyByteBuf)this.data);
        }
    }
}

