/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.tool.ChemthrowerHandler;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.ChemthrowerShotEntity;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.items.IItemHandler;

public class ChemthrowerItem
extends UpgradeableToolItem
implements IEItemInterfaces.IAdvancedFluidItem,
IEItemInterfaces.IScrollwheel {
    private static final int CAPACITY = 2000;

    public ChemthrowerItem() {
        super(new Item.Properties().stacksTo(1), "CHEMTHROWER");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        int cap = this.getCapacity(stack, 2000);
        int numberOfTanks = this.getUpgrades(stack).getBoolean("multitank") ? 3 : 1;
        for (int i = 0; i < numberOfTanks; ++i) {
            Component add = IEItemFluidHandler.fluidItemInfoFlavor(ItemNBTHelper.getFluidStack(stack, "Fluid" + (Serializable)(i > 0 ? Integer.valueOf(i) : "")), cap);
            if (i > 0) {
                TextUtils.applyFormat(add, ChatFormatting.GRAY);
            }
            list.add(add);
        }
    }

    @Nonnull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            if (!world.isClientSide) {
                ChemthrowerItem.setIgniteEnable(stack, !ChemthrowerItem.isIgniteEnable(stack));
            }
        } else {
            player.startUsingItem(hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int remainingUseDuration) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty()) {
            int duration = this.getUseDuration(stack) - remainingUseDuration;
            int consumed = (Integer)IEServerConfig.TOOLS.chemthrower_consumption.get();
            if (consumed * duration <= fs.getAmount()) {
                float range;
                Vec3 v = player.getLookAngle();
                int split = 8;
                boolean isGas = fs.getFluid().is(Tags.Fluids.GASEOUS);
                float scatter = isGas ? 0.25f : 0.15f;
                float f = range = isGas ? 0.5f : 1.0f;
                if (this.getUpgrades(stack).getBoolean("focus")) {
                    range += 0.25f;
                    scatter = 0.025f;
                }
                boolean ignite = ChemthrowerHandler.isFlammable(fs.getFluid()) && ChemthrowerItem.isIgniteEnable(stack);
                for (int i = 0; i < split; ++i) {
                    Vec3 vecDir = v.add(player.getRandom().nextGaussian() * (double)scatter, player.getRandom().nextGaussian() * (double)scatter, player.getRandom().nextGaussian() * (double)scatter);
                    ChemthrowerShotEntity chem = new ChemthrowerShotEntity(player.level(), player, vecDir.x * 0.25, vecDir.y * 0.25, vecDir.z * 0.25, fs);
                    chem.setDeltaMovement(player.getDeltaMovement().add(vecDir.scale((double)range)));
                    if (!player.onGround()) {
                        player.setDeltaMovement(player.getDeltaMovement().subtract(vecDir.scale(0.0025 * (double)range)));
                    }
                    if (ignite) {
                        chem.setSecondsOnFire(10);
                    }
                    if (player.level().isClientSide) continue;
                    player.level().addFreshEntity((Entity)chem);
                }
                if (remainingUseDuration % 4 == 0) {
                    if (ignite) {
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)IESounds.sprayFire.value(), SoundSource.PLAYERS, 0.5f, 1.5f);
                    } else {
                        player.level().playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)IESounds.spray.value(), SoundSource.PLAYERS, 0.5f, 0.75f);
                    }
                }
            } else {
                player.releaseUsingItem();
            }
        } else {
            player.releaseUsingItem();
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity player, int timeLeft) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty()) {
            int duration = this.getUseDuration(stack) - timeLeft;
            fs.shrink((Integer)IEServerConfig.TOOLS.chemthrower_consumption.get() * duration);
            if (fs.getAmount() <= 0) {
                ItemNBTHelper.remove(stack, "Fluid");
            } else {
                ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
            }
        }
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    @Override
    public void onScrollwheel(ItemStack stack, Player playerEntity, boolean forward) {
        if (this.getUpgrades(stack).getBoolean("multitank")) {
            CompoundTag fluidTag = ItemNBTHelper.getTagCompound(stack, "Fluid");
            CompoundTag fluidTag1 = ItemNBTHelper.getTagCompound(stack, "Fluid1");
            CompoundTag fluidTag2 = ItemNBTHelper.getTagCompound(stack, "Fluid2");
            if (forward) {
                ItemNBTHelper.setTagCompound(stack, "Fluid", fluidTag2);
                ItemNBTHelper.setTagCompound(stack, "Fluid1", fluidTag);
                ItemNBTHelper.setTagCompound(stack, "Fluid2", fluidTag1);
            } else {
                ItemNBTHelper.setTagCompound(stack, "Fluid", fluidTag1);
                ItemNBTHelper.setTagCompound(stack, "Fluid1", fluidTag2);
                ItemNBTHelper.setTagCompound(stack, "Fluid2", fluidTag);
            }
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        FluidStack fs = this.getFluid(stack);
        if (!fs.isEmpty() && fs.getAmount() > this.getCapacity(stack, 2000)) {
            fs.setAmount(this.getCapacity(stack, 2000));
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged || CapabilityShader.shouldReequipDueToShader(oldStack, newStack)) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        ChemthrowerItem.registerCapabilitiesISI(registrar);
        registrar.register(Capabilities.FluidHandler.ITEM, stack -> new IEItemFluidHandler((ItemStack)stack, 2000));
        registrar.register(CapabilityShader.ITEM, stack -> new CapabilityShader.ShaderWrapper_Item(IEApi.ieLoc("chemthrower"), (ItemStack)stack));
    }

    @Override
    public int getSlotCount() {
        return 4;
    }

    @Override
    public int getCapacity(ItemStack stack, int baseCapacity) {
        return baseCapacity + this.getUpgrades(stack).getInt("capacity");
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 80, 32, "CHEMTHROWER", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 100, 32, "CHEMTHROWER", stack, true, level, getPlayer)};
    }

    public static void setIgniteEnable(ItemStack chemthrower, boolean enabled) {
        chemthrower.getOrCreateTag().putBoolean("ignite", enabled);
    }

    public static boolean isIgniteEnable(ItemStack chemthrower) {
        return ItemNBTHelper.getBoolean(chemthrower, "ignite");
    }
}

