/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.api.excavator.MineralWorldInfo;
import blusunrize.immersiveengineering.client.utils.TimestampFormat;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlock;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;

public class CoresampleItem
extends IEBaseItem {
    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        CoresampleItem.getCoresampleInfo(stack, list, ChatFormatting.GRAY, world, true, true);
    }

    public static void getCoresampleInfo(ItemStack coresample, List<Component> list, ChatFormatting baseColor, @Nullable Level world, boolean showYield, boolean showTimestamp) {
        ColumnPos coords;
        if (coresample.getOrCreateTag().contains("coords")) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.outdated"));
        }
        if ((coords = CoresampleItem.getCoords(coresample)) != null) {
            ColumnPos pos;
            List<VeinSampleData> veins = CoresampleItem.getVeins(world, coresample);
            if (!veins.isEmpty()) {
                veins.forEach(data -> {
                    MutableComponent component = Component.literal((String)(Utils.formatDouble(data.getPercentageInTotalSample() * 100.0, "0.00") + "% "));
                    MineralMix mineral = data.getType();
                    component.append((Component)Component.translatable((String)MineralMix.getTranslationKey(data.type.id())));
                    list.add((Component)component.withStyle(baseColor));
                    if (showYield) {
                        component = Component.literal((String)"  ");
                        component.append((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.saturation", (Object[])new Object[]{Utils.formatDouble(data.getSaturation() * 100.0, "0.00")}));
                        list.add((Component)component.withStyle(ChatFormatting.DARK_GRAY));
                        component = Component.literal((String)"  ");
                        int yield_ = ExcavatorHandler.mineralVeinYield - data.getDepletion();
                        yield_ = (int)((float)yield_ * (1.0f - mineral.failChance));
                        if (ExcavatorHandler.mineralVeinYield == 0) {
                            component.append((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.infinite"));
                        } else {
                            component.append((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.yield", (Object[])new Object[]{yield_}));
                        }
                        list.add((Component)component.withStyle(ChatFormatting.DARK_GRAY));
                    }
                });
            } else {
                list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.noMineral").withStyle(baseColor));
            }
            ResourceKey<Level> dimension = CoresampleItem.getDimension(coresample);
            if (dimension != null) {
                String s2 = dimension.location().getPath();
                if (s2.toLowerCase(Locale.ENGLISH).startsWith("the_")) {
                    s2 = s2.substring(4);
                }
                list.add((Component)Component.literal((String)Utils.toCamelCase(s2)).withStyle(baseColor));
            }
            if ((pos = CoresampleItem.getCoords(coresample)) != null) {
                list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.pos", (Object[])new Object[]{pos.x(), pos.z()}).withStyle(baseColor));
            }
            if (showTimestamp) {
                boolean hasStamp = ItemNBTHelper.hasKey(coresample, "timestamp");
                if (hasStamp && world != null) {
                    long timestamp = ItemNBTHelper.getLong(coresample, "timestamp");
                    long dist = world.getGameTime() - timestamp;
                    if (dist < 0L) {
                        list.add((Component)Component.literal((String)"Somehow this sample is dated in the future...are you a time traveller?!").withStyle(ChatFormatting.RED));
                    } else {
                        list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.timestamp", (Object[])new Object[]{TimestampFormat.formatTimestamp(dist, TimestampFormat.DHM)}).withStyle(baseColor));
                    }
                } else if (hasStamp) {
                    list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.timezone").withStyle(baseColor));
                } else {
                    list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.coresample.noTimestamp").withStyle(baseColor));
                }
            }
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        Player player = ctx.getPlayer();
        ItemStack stack = ctx.getItemInHand();
        if (player != null && player.isShiftKeyDown()) {
            BlockPlaceContext blockCtx;
            Level world = ctx.getLevel();
            BlockPos pos = ctx.getClickedPos();
            Direction side = ctx.getClickedFace();
            BlockState state = world.getBlockState(pos);
            if (!state.canBeReplaced(blockCtx = new BlockPlaceContext(ctx))) {
                pos = pos.relative(side);
            }
            if (!stack.isEmpty() && player.mayUseItemAt(pos, side, stack) && world.getBlockState(pos).canBeReplaced(blockCtx)) {
                BlockState coresample = IEBlocks.StoneDecoration.CORESAMPLE.defaultBlockState();
                if (world.setBlock(pos, coresample, 3)) {
                    ((IEBaseBlock)IEBlocks.StoneDecoration.CORESAMPLE.get()).onIEBlockPlacedBy(blockCtx, coresample);
                    SoundType soundtype = world.getBlockState(pos).getBlock().getSoundType(world.getBlockState(pos), (LevelReader)world, pos, (Entity)player);
                    world.playSound(player, pos, soundtype.getPlaceSound(), SoundSource.BLOCKS, (soundtype.getVolume() + 1.0f) / 2.0f, soundtype.getPitch() * 0.8f);
                    stack.shrink(1);
                }
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        return super.useOn(ctx);
    }

    public static List<RecipeHolder<MineralMix>> getMineralMixes(Level level, ItemStack coresample) {
        return CoresampleItem.getVeins(level, coresample).stream().map(VeinSampleData::getTypeHolder).toList();
    }

    public static ListTag getSimplifiedMineralList(Level level, ItemStack coresample) {
        ListTag outList = new ListTag();
        CoresampleItem.getVeins(level, coresample).stream().map(VeinSampleData::getTypeHolder).map(RecipeHolder::id).map(ResourceLocation::toString).map(StringTag::valueOf).forEach(arg_0 -> outList.add(arg_0));
        return outList;
    }

    public static void setMineralInfo(Level level, ItemStack stack, MineralWorldInfo info, BlockPos pos) {
        if (info == null) {
            return;
        }
        List<Pair<MineralVein, Integer>> veins = info.getAllVeins();
        ListTag nbtList = new ListTag();
        veins.forEach(pair -> {
            VeinSampleData sampleData = new VeinSampleData(((MineralVein)pair.getFirst()).getMineralHolder(level), (double)((Integer)pair.getSecond()).intValue() / (double)info.getTotalWeight(), 1.0 - ((MineralVein)pair.getFirst()).getFailChance(pos), ((MineralVein)pair.getFirst()).getDepletion());
            nbtList.add((Object)sampleData.toNBT());
        });
        stack.getOrCreateTag().put("mineralInfo", (Tag)nbtList);
    }

    public static List<VeinSampleData> getVeins(@Nullable Level level, ItemStack stack) {
        if (level == null || !ItemNBTHelper.hasKey(stack, "mineralInfo", 9)) {
            return ImmutableList.of();
        }
        ArrayList<VeinSampleData> veins = new ArrayList<VeinSampleData>();
        ListTag mineralInfoNBT = stack.getOrCreateTag().getList("mineralInfo", 10);
        for (Tag vein : mineralInfoNBT) {
            VeinSampleData data = VeinSampleData.fromNBT(level, (CompoundTag)vein);
            if (data == null) continue;
            veins.add(data);
        }
        return veins;
    }

    @Nullable
    public static ColumnPos getCoords(@Nullable ItemStack stack) {
        if (stack != null && stack.hasTag() && stack.getOrCreateTag().contains("x")) {
            return new ColumnPos(stack.getOrCreateTag().getInt("x"), stack.getOrCreateTag().getInt("z"));
        }
        return null;
    }

    public static void setCoords(ItemStack stack, BlockPos pos) {
        stack.getOrCreateTag().putInt("x", pos.getX());
        stack.getOrCreateTag().putInt("z", pos.getZ());
    }

    @Nullable
    public static ResourceKey<Level> getDimension(ItemStack stack) {
        if (stack.hasTag() && stack.getOrCreateTag().contains("dimension")) {
            ResourceLocation name = new ResourceLocation(stack.getOrCreateTag().getString("dimension"));
            return ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)name);
        }
        return null;
    }

    public static void setDimension(ItemStack stack, ResourceKey<Level> dimension) {
        stack.getOrCreateTag().putString("dimension", dimension.location().toString());
    }

    public static class VeinSampleData {
        private final RecipeHolder<MineralMix> type;
        private final double percentageInTotalSample;
        private final double saturation;
        private final int depletion;

        public VeinSampleData(RecipeHolder<MineralMix> type, double percentageInTotalSample, double saturation, int depletion) {
            this.type = type;
            this.percentageInTotalSample = percentageInTotalSample;
            this.saturation = saturation;
            this.depletion = depletion;
        }

        @Nullable
        public static VeinSampleData fromNBT(Level level, CompoundTag nbt) {
            ResourceLocation id = new ResourceLocation(nbt.getString("mineral"));
            MineralMix mineral = MineralMix.RECIPES.getById(level, id);
            if (mineral == null) {
                return null;
            }
            return new VeinSampleData((RecipeHolder<MineralMix>)new RecipeHolder(id, (Recipe)mineral), nbt.getDouble("percentage"), nbt.getDouble("saturation"), nbt.getInt("depletion"));
        }

        public CompoundTag toNBT() {
            CompoundTag tag = new CompoundTag();
            tag.putDouble("percentage", this.percentageInTotalSample);
            tag.putString("mineral", this.type.id().toString());
            tag.putInt("depletion", this.depletion);
            tag.putDouble("saturation", this.saturation);
            return tag;
        }

        public MineralMix getType() {
            return (MineralMix)this.type.value();
        }

        public RecipeHolder<MineralMix> getTypeHolder() {
            return this.type;
        }

        public double getPercentageInTotalSample() {
            return this.percentageInTotalSample;
        }

        public double getSaturation() {
            return this.saturation;
        }

        public int getDepletion() {
            return this.depletion;
        }
    }
}

