/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.common.TierSortingRegistry;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class DieselToolItem
extends UpgradeableToolItem
implements IEItemInterfaces.IAdvancedFluidItem {
    protected static final int CAPACITY = 2000;
    private final Map<UUID, Integer> animationTimer = new HashMap<UUID, Integer>();

    public DieselToolItem(Item.Properties props, String upgradeType) {
        super(props, upgradeType);
    }

    public int getEnchantmentValue() {
        return 0;
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        DieselToolItem.registerCapabilitiesISI(registrar);
        registrar.register(Capabilities.FluidHandler.ITEM, (stack, $) -> new IEItemFluidHandler((ItemStack)stack, 2000));
        registrar.register(CapabilityShader.ITEM, stack -> new CapabilityShader.ShaderWrapper_Item(BuiltInRegistries.ITEM.getKey((Object)stack.getItem()), (ItemStack)stack));
    }

    public int getBarWidth(@Nonnull ItemStack stack) {
        return Math.round(13.0f * (1.0f - (float)this.getHeadDamage(stack) / (float)this.getMaxHeadDamage(stack)));
    }

    public boolean isBarVisible(@Nonnull ItemStack stack) {
        return this.getHeadDamage(stack) > 0;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        super.finishUpgradeRecalculation(stack);
        FluidStack fs = this.getFluid(stack);
        if (fs != null && fs.getAmount() > this.getCapacity(stack, 2000)) {
            fs.setAmount(this.getCapacity(stack, 2000));
            ItemNBTHelper.setFluidStack(stack, "Fluid", fs);
        }
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity player) {
        this.consumeDurability(stack, target.getCommandSenderWorld(), null, null, player);
        return true;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    @Override
    public int getCapacity(ItemStack container, int baseCapacity) {
        return baseCapacity + this.getUpgrades(container).getInt("capacity");
    }

    @Override
    public boolean allowFluid(ItemStack container, FluidStack fluid) {
        return fluid != null && fluid.getFluid().is(IETags.drillFuel);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        Tier tier = this.getHarvestLevel(stack, null);
        if (tier == null) {
            return false;
        }
        return this.isEffective(stack, state) && this.canToolBeUsed(stack) && TierSortingRegistry.isCorrectTierForDrops((Tier)tier, (BlockState)state);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ItemStack head;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND && !(head = this.getHead(stack)).isEmpty() && this.canToolBeUsed(stack)) {
            builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Tool modifier", this.getAttackDamage(stack, head), AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Tool modifier", -2.5, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged || CapabilityShader.shouldReequipDueToShader(oldStack, newStack)) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (this.canToolBeUsed(stack)) {
            if (!this.animationTimer.containsKey(entity.getUUID())) {
                this.animationTimer.put(entity.getUUID(), 40);
            } else if (this.animationTimer.get(entity.getUUID()) < 20) {
                this.animationTimer.put(entity.getUUID(), 20);
            }
        }
        return true;
    }

    protected int getToolDamageFromBlock(ItemStack stack, @Nullable BlockState state) {
        return state == null || this.isEffective(stack, state) ? 1 : 3;
    }

    protected void consumeDurability(ItemStack stack, Level world, @Nullable BlockState state, @Nullable BlockPos pos, LivingEntity living) {
        Preconditions.checkArgument((pos == null == (state == null) ? 1 : 0) != 0);
        if (state == null || state.getDestroySpeed((BlockGetter)world, pos) != 0.0f) {
            int dmg = this.getToolDamageFromBlock(stack, state);
            ItemStack head = this.getHead(stack);
            if (!head.isEmpty()) {
                if (!this.getUpgrades(stack).getBoolean("oiled") || ApiUtils.RANDOM.nextInt(4) == 0) {
                    this.damageHead(head, dmg, living);
                }
                this.setHead(stack, head);
                IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)stack).orElseThrow(RuntimeException::new);
                handler.drain(1, IFluidHandler.FluidAction.EXECUTE);
                ShaderRegistry.ShaderAndCase shader = ShaderRegistry.getStoredShaderAndCase(stack);
                if (shader != null) {
                    Vec3 particlePos = pos != null ? Vec3.atCenterOf((Vec3i)pos) : living.position();
                    shader.registryEntry().getEffectFunction().execute(world, shader.shader(), stack, shader.sCase().getShaderType().toString(), particlePos, null, 0.375f);
                }
            }
        }
    }

    protected abstract void damageHead(ItemStack var1, int var2, LivingEntity var3);

    protected abstract double getAttackDamage(ItemStack var1, ItemStack var2);

    public abstract boolean isEffective(ItemStack var1, BlockState var2);

    public abstract Tier getHarvestLevel(ItemStack var1, @Nullable Player var2);

    public abstract boolean canToolBeUsed(ItemStack var1);

    protected abstract ItemStack getHead(ItemStack var1);

    protected abstract void setHead(ItemStack var1, ItemStack var2);

    public abstract int getMaxHeadDamage(ItemStack var1);

    public abstract int getHeadDamage(ItemStack var1);
}

