/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.tool.IDrillHead;
import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.DieselToolItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.common.CommonHooks;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.fluids.FluidType;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

@Mod.EventBusSubscriber(modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DrillItem
extends DieselToolItem {
    public DrillItem() {
        super(new Item.Properties().stacksTo(1), "DRILL");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    @Override
    public int getSlotCount() {
        return 5;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.WithPredicate(toolInventory, 0, 98, 22, itemStack -> itemStack.getItem() instanceof IDrillHead), new IESlot.Upgrades(container, toolInventory, 1, 78, 52, "DRILL", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 2, 98, 52, "DRILL", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 3, 118, 52, "DRILL", stack, true, level, getPlayer)};
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (!(inv == null || inv.getStackInSlot(0).isEmpty() || inv.getStackInSlot(1).isEmpty() || inv.getStackInSlot(2).isEmpty() || inv.getStackInSlot(3).isEmpty())) {
            Utils.unlockIEAdvancement(player, "tools/upgrade_drill");
        }
    }

    @Override
    public void finishUpgradeRecalculation(ItemStack stack) {
        super.finishUpgradeRecalculation(stack);
        Map enchants = DrillItem.getUpgradesStatic(stack).getBoolean("fortune") ? Collections.singletonMap(Enchantments.BLOCK_FORTUNE, 3) : Collections.emptyMap();
        EnchantmentHelper.setEnchantments(enchants, (ItemStack)stack);
    }

    @Override
    public final ItemStack getHead(ItemStack drill) {
        return DrillItem.getHeadStatic(drill);
    }

    public static ItemStack getHeadStatic(ItemStack drill) {
        IItemHandler cap = (IItemHandler)drill.getCapability(Capabilities.ItemHandler.ITEM);
        if (cap != null) {
            ItemStack head = cap.getStackInSlot(0);
            return !head.isEmpty() && head.getItem() instanceof IDrillHead ? head : ItemStack.EMPTY;
        }
        return ItemStack.EMPTY;
    }

    @Override
    public void setHead(ItemStack drill, ItemStack head) {
        IItemHandler inv = (IItemHandler)drill.getCapability(Capabilities.ItemHandler.ITEM);
        ((IItemHandlerModifiable)inv).setStackInSlot(0, head);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add(IEItemFluidHandler.fluidItemInfoFlavor(this.getFluid(stack), this.getCapacity(stack, 2000)));
        if (this.getHead(stack).isEmpty()) {
            list.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drill.noHead"), ChatFormatting.GRAY));
        } else {
            int maxDmg = this.getMaxHeadDamage(stack);
            int dmg = maxDmg - this.getHeadDamage(stack);
            float quote = (float)dmg / (float)maxDmg;
            ChatFormatting status = (double)quote < 0.1 ? ChatFormatting.RED : ((double)quote < 0.3 ? ChatFormatting.GOLD : ((double)quote < 0.6 ? ChatFormatting.YELLOW : ChatFormatting.GREEN));
            list.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.flavour.drill.headDamage"), ChatFormatting.GRAY).append(" ").append((Component)TextUtils.applyFormat((Component)Component.translatable((String)"desc.immersiveengineering.info.percent", (Object[])new Object[]{(int)(quote * 100.0f)}), status)));
        }
    }

    @Override
    protected double getAttackDamage(ItemStack stack, ItemStack head) {
        return ((IDrillHead)head.getItem()).getAttackDamage(head) + (float)this.getUpgrades(stack).getInt("damage");
    }

    public static boolean isSingleBlockMode(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, "singleBlockMode");
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            boolean mode = !DrillItem.isSingleBlockMode(stack);
            stack.getOrCreateTag().putBoolean("singleBlockMode", mode);
            player.displayClientMessage((Component)Component.translatable((String)("chat.immersiveengineering.info.drill_mode." + (mode ? "single" : "multi"))), true);
            return InteractionResultHolder.success((Object)stack);
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    @Override
    public boolean canToolBeUsed(ItemStack drill) {
        return this.getHeadDamage(drill) < this.getMaxHeadDamage(drill) && !this.getFluid(drill).isEmpty();
    }

    @SubscribeEvent
    public static void handleUnderwaterDrill(PlayerEvent.HarvestCheck ev) {
        ItemStack drill = ev.getEntity().getInventory().getSelected();
        Item item = drill.getItem();
        if (!(item instanceof DrillItem)) {
            return;
        }
        DrillItem drillItem = (DrillItem)item;
        if (ev.getEntity().isEyeInFluidType((FluidType)NeoForgeMod.WATER_TYPE.value()) && !drillItem.getUpgrades(drill).getBoolean("waterproof")) {
            ev.setCanHarvest(false);
        }
    }

    @Override
    public int getMaxHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.isEmpty() ? ((IDrillHead)head.getItem()).getMaximumHeadDamage(head) : 0;
    }

    @Override
    public int getHeadDamage(ItemStack stack) {
        ItemStack head = this.getHead(stack);
        return !head.isEmpty() ? ((IDrillHead)head.getItem()).getHeadDamage(head) : 0;
    }

    public boolean mineBlock(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity living) {
        ItemStack head;
        if (state.getDestroySpeed((BlockGetter)world, pos) != 0.0f && !(head = this.getHead(stack)).isEmpty()) {
            if (living instanceof Player) {
                if (((Player)living).getAbilities().instabuild) {
                    return true;
                }
                ((IDrillHead)head.getItem()).afterBlockbreak(stack, head, (Player)living);
            }
            this.consumeDurability(stack, world, state, pos, living);
        }
        return true;
    }

    @Override
    protected void damageHead(ItemStack head, int amount, LivingEntity living) {
        ((IDrillHead)head.getItem()).damageHead(head, amount);
    }

    @Override
    public Tier getHarvestLevel(ItemStack stack, @Nullable Player player) {
        ItemStack head = this.getHead(stack);
        if (!head.isEmpty() && this.canToolBeUsed(stack)) {
            return ((IDrillHead)head.getItem()).getMiningLevel(head);
        }
        return null;
    }

    @Override
    public boolean isEffective(ItemStack stack, BlockState state) {
        return state.is(IETags.drillHarvestable);
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        ItemStack head = this.getHead(stack);
        if (!head.isEmpty() && this.canToolBeUsed(stack)) {
            return ((IDrillHead)head.getItem()).getMiningSpeed(head) + this.getUpgrades(stack).getFloat("speed");
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean canBreakExtraBlock(Level world, BlockPos pos, BlockState state, Player player, ItemStack drill, ItemStack head) {
        if (!(state.canHarvestBlock((BlockGetter)world, pos, player) && this.isEffective(drill, state) && this.canToolBeUsed(drill))) {
            return false;
        }
        return !((IDrillHead)head.getItem()).beforeBlockbreak(drill, head, player);
    }

    public boolean onBlockStartBreak(ItemStack stack, BlockPos iPos, Player player) {
        Level world = player.level();
        if (world.isClientSide || !(player instanceof ServerPlayer)) {
            return false;
        }
        if (player.isShiftKeyDown() || DrillItem.isSingleBlockMode(stack)) {
            return false;
        }
        BlockHitResult mop = DrillItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack head = this.getHead(stack);
        if (mop == null || head.isEmpty() || !this.canToolBeUsed(stack)) {
            return false;
        }
        ImmutableList<BlockPos> additional = ((IDrillHead)head.getItem()).getExtraBlocksDug(head, world, player, (HitResult)mop);
        for (BlockPos pos : additional) {
            int xpDropEvent;
            if (!world.hasChunkAt(pos)) continue;
            BlockState state = world.getBlockState(pos);
            Block block = state.getBlock();
            if (state.isAir() || state.getDestroyProgress(player, (BlockGetter)world, pos) == 0.0f || !this.canBreakExtraBlock(world, pos, state, player, stack, head) || (xpDropEvent = CommonHooks.onBlockBreakEvent((Level)world, (GameType)((ServerPlayer)player).gameMode.getGameModeForPlayer(), (ServerPlayer)((ServerPlayer)player), (BlockPos)pos)) < 0) continue;
            if (player.getAbilities().instabuild) {
                if (block.onDestroyedByPlayer(state, world, pos, player, false, state.getFluidState())) {
                    block.destroy((LevelAccessor)world, pos, state);
                }
            } else {
                BlockEntity te = world.getBlockEntity(pos);
                stack.mineBlock(world, state, pos, player);
                if (block.onDestroyedByPlayer(state, world, pos, player, true, state.getFluidState())) {
                    block.destroy((LevelAccessor)world, pos, state);
                    block.playerDestroy(world, player, pos, state, te, stack);
                    if (world instanceof ServerLevel) {
                        block.popExperience((ServerLevel)world, pos, xpDropEvent);
                    }
                }
            }
            world.levelEvent(2001, pos, Block.getId((BlockState)state));
            ((ServerPlayer)player).connection.send((Packet)new ClientboundBlockUpdatePacket((BlockGetter)world, pos));
        }
        return false;
    }
}

