/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IConfigurableTool;
import blusunrize.immersiveengineering.client.utils.FontUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.util.ItemGetterList;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.Sets;
import java.util.LinkedHashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.DyeableLeatherItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class EarmuffsItem
extends IEBaseItem
implements DyeableLeatherItem,
IConfigurableTool,
IEItemInterfaces.IColouredItem {
    public static final float MIN_MULTIPLIER = 0.05f;
    public static final float MAX_REDUCTION = 0.95f;
    public static ItemGetterList EARMUFF_GETTERS = new ItemGetterList(entity -> {
        ItemStack head = entity.getItemBySlot(EquipmentSlot.HEAD);
        if (head.getItem() instanceof EarmuffsItem) {
            return head;
        }
        if (ItemNBTHelper.hasKey(head, "IE:Earmuffs")) {
            return ItemNBTHelper.getItemStack(head, "IE:Earmuffs");
        }
        return ItemStack.EMPTY;
    });
    public static LinkedHashSet<String> affectedSoundCategories = Sets.newLinkedHashSet();

    public EarmuffsItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Nullable
    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.HEAD;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int renderPass) {
        if (renderPass == 1) {
            return 0xFFFFFF;
        }
        if (!ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            return 4746388;
        }
        return ItemNBTHelper.getInt(stack, "IE:EarmuffColour");
    }

    public boolean hasCustomColor(ItemStack stack) {
        return true;
    }

    public int getColor(ItemStack stack) {
        if (!ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            return 4746388;
        }
        return ItemNBTHelper.getInt(stack, "IE:EarmuffColour");
    }

    public void clearColor(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "IE:EarmuffColour")) {
            ItemNBTHelper.remove(stack, "IE:EarmuffColour");
        }
    }

    public void setColor(ItemStack stack, int color) {
        ItemNBTHelper.putInt(stack, "IE:EarmuffColour", color);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        int color = this.getColourForIEItem(stack, 0);
        MutableComponent mainComponent = Component.translatable((String)"desc.immersiveengineering.info.colour").withStyle(ChatFormatting.GRAY);
        list.add((Component)FontUtils.withAppendColoredColour(mainComponent, color));
    }

    public static float getVolumeMod(ItemStack stack) {
        if (!ItemNBTHelper.hasKey(stack, "IE:Earmuffs:Volume")) {
            return 0.1f;
        }
        return ItemNBTHelper.getFloat(stack, "IE:Earmuffs:Volume");
    }

    @Override
    public boolean canConfigure(ItemStack stack) {
        return true;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigBoolean[] getBooleanOptions(ItemStack stack) {
        IConfigurableTool.ToolConfig.ToolConfigBoolean[] array = new IConfigurableTool.ToolConfig.ToolConfigBoolean[affectedSoundCategories.size()];
        int i = -1;
        for (String cat : affectedSoundCategories) {
            int n = 60 + ++i / 4 * 55;
            array[i] = new IConfigurableTool.ToolConfig.ToolConfigBoolean(cat, n, 32 + 10 * (i % 4), !ItemNBTHelper.getBoolean(stack, "IE:Earmuffs:Cat_" + cat));
        }
        return array;
    }

    @Override
    public IConfigurableTool.ToolConfig.ToolConfigFloat[] getFloatOptions(ItemStack stack) {
        return new IConfigurableTool.ToolConfig.ToolConfigFloat[]{new IConfigurableTool.ToolConfig.ToolConfigFloat("reductionValue", 60, 20, 0.95f - EarmuffsItem.getVolumeMod(stack), 0.0f, 0.95f)};
    }

    @Override
    public String fomatConfigName(ItemStack stack, IConfigurableTool.ToolConfig config) {
        if (config instanceof IConfigurableTool.ToolConfig.ToolConfigFloat) {
            return I18n.get((String)"gui.immersiveengineering.config.earmuffs.noisegate", (Object[])new Object[0]);
        }
        return I18n.get((String)("gui.immersiveengineering.config.earmuffs.soundcategory." + config.name), (Object[])new Object[0]);
    }

    @Override
    public String fomatConfigDescription(ItemStack stack, IConfigurableTool.ToolConfig config) {
        return null;
    }

    @Override
    public void applyConfigOption(ItemStack stack, String key, Object value) {
        if (value instanceof Boolean) {
            Boolean bool = (Boolean)value;
            ItemNBTHelper.putBoolean(stack, "IE:Earmuffs:Cat_" + key, bool == false);
        } else if (value instanceof Float) {
            Float flt = (Float)value;
            ItemNBTHelper.putFloat(stack, "IE:Earmuffs:Volume", 0.95f - flt.floatValue());
        }
    }

    static {
        affectedSoundCategories.add("ambient");
        affectedSoundCategories.add("weather");
        affectedSoundCategories.add("record");
        affectedSoundCategories.add("block");
        affectedSoundCategories.add("neutral");
        affectedSoundCategories.add("hostile");
        affectedSoundCategories.add("player");
    }
}

