/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.crafting.BlueprintCraftingRecipe;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class EngineersBlueprintItem
extends IEBaseItem {
    public EngineersBlueprintItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Nonnull
    public String getDescriptionId(ItemStack stack) {
        return this.getDescriptionId();
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        String formatted;
        String key = EngineersBlueprintItem.getCategory(stack);
        if (key.isEmpty()) {
            return;
        }
        String formatKey = "desc.immersiveengineering.info.blueprint." + key;
        if (formatKey.equals(formatted = I18n.get((String)formatKey, (Object[])new Object[0]))) {
            list.add((Component)Component.literal((String)key).withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)formatKey).withStyle(ChatFormatting.GRAY));
        }
        if (world == null) {
            return;
        }
        List<RecipeHolder<BlueprintCraftingRecipe>> recipes = BlueprintCraftingRecipe.findRecipes(world, key);
        if (recipes.isEmpty()) {
            return;
        }
        if (Screen.hasShiftDown()) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.blueprint.creates1").withStyle(ChatFormatting.GRAY));
            for (RecipeHolder<BlueprintCraftingRecipe> recipe : recipes) {
                list.add((Component)Component.literal((String)" ").append(((BlueprintCraftingRecipe)recipe.value()).output.get().getHoverName()).withStyle(ChatFormatting.DARK_GRAY));
            }
        } else {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.blueprint.creates0").withStyle(ChatFormatting.GRAY));
        }
    }

    @Override
    public void fillCreativeTab(CreativeModeTab.Output out) {
        Level level = ImmersiveEngineering.proxy.getClientWorld();
        if (level != null) {
            for (String key : BlueprintCraftingRecipe.getCategoriesWithRecipes(level)) {
                ItemStack stack = new ItemStack((ItemLike)this);
                ItemNBTHelper.putString(stack, "blueprint", key);
                out.accept(stack);
            }
        }
    }

    @Nonnull
    public static List<RecipeHolder<BlueprintCraftingRecipe>> getRecipes(Level level, ItemStack stack) {
        return BlueprintCraftingRecipe.findRecipes(level, EngineersBlueprintItem.getCategory(stack));
    }

    public static String getCategory(ItemStack stack) {
        return ItemNBTHelper.getString(stack, "blueprint");
    }
}

