/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class FaradaySuitItem
extends ArmorItem
implements IElectricEquipment {
    public static ArmorMaterial mat = new FaradayArmorMaterial();

    public FaradaySuitItem(ArmorItem.Type type) {
        super(mat, type, new Item.Properties().stacksTo(1));
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlot eqSlot, LivingEntity owner, Map<String, Object> cache, @Nullable DamageSource dSource, IElectricEquipment.ElectricSource eSource) {
        if (!(dSource instanceof IEDamageSources.ElectricDamageSource)) {
            return;
        }
        IEDamageSources.ElectricDamageSource dmg = (IEDamageSources.ElectricDamageSource)dSource;
        if ((double)dmg.source.level < 1.75) {
            if (cache.containsKey("faraday")) {
                cache.put("faraday", 1 << this.type.ordinal() | (Integer)cache.get("faraday"));
            } else {
                cache.put("faraday", 1 << this.type.ordinal());
            }
            if (cache.containsKey("faraday") && (Integer)cache.get("faraday") == 15) {
                dmg.dmg = 0.0f;
            }
        } else {
            dmg.dmg = (float)((double)dmg.dmg * 1.2);
            if (!(owner instanceof Player && ((Player)owner).getAbilities().instabuild || !equipped.hurt(2, ApiUtils.RANDOM_SOURCE, dmg.getEntity() instanceof ServerPlayer ? (ServerPlayer)dmg.getEntity() : null))) {
                owner.setItemSlot(eqSlot, ItemStack.EMPTY);
            }
        }
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "immersiveengineering:textures/models/armor_faraday" + (slot == EquipmentSlot.LEGS ? "_legs" : "") + ".png";
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    private static class FaradayArmorMaterial
    implements ArmorMaterial {
        private FaradayArmorMaterial() {
        }

        public int getDurabilityForType(ArmorItem.Type slotIn) {
            return switch (slotIn) {
                default -> throw new IncompatibleClassChangeError();
                case ArmorItem.Type.BOOTS -> 13;
                case ArmorItem.Type.LEGGINGS -> 15;
                case ArmorItem.Type.CHESTPLATE -> 16;
                case ArmorItem.Type.HELMET -> 11;
            };
        }

        public int getDefenseForType(ArmorItem.Type slotIn) {
            return switch (slotIn) {
                default -> throw new IncompatibleClassChangeError();
                case ArmorItem.Type.BOOTS, ArmorItem.Type.HELMET -> 1;
                case ArmorItem.Type.LEGGINGS -> 2;
                case ArmorItem.Type.CHESTPLATE -> 3;
            };
        }

        public int getEnchantmentValue() {
            return 0;
        }

        @Nonnull
        public SoundEvent getEquipSound() {
            return SoundEvents.ARMOR_EQUIP_CHAIN;
        }

        @Nonnull
        public Ingredient getRepairIngredient() {
            return Ingredient.of(IETags.getTagsFor((EnumMetals)EnumMetals.ALUMINUM).plate);
        }

        @Nonnull
        public String getName() {
            return "immersiveengineering:faraday";
        }

        public float getToughness() {
            return 0.0f;
        }

        public float getKnockbackResistance() {
            return 0.0f;
        }
    }
}

