/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.IESounds;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Equipable;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;

public class GliderItem
extends IEBaseItem
implements Equipable {
    public GliderItem() {
        super(new Item.Properties().stacksTo(1).durability(216));
        DispenserBlock.registerBehavior((ItemLike)this, (DispenseItemBehavior)ArmorItem.DISPENSE_ITEM_BEHAVIOR);
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack material) {
        return material.is(IETags.fabricHemp);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand hand) {
        ItemStack heldItem = player.getItemInHand(hand);
        EquipmentSlot slot = Mob.getEquipmentSlotForItem((ItemStack)heldItem);
        ItemStack equipped = player.getItemBySlot(slot);
        if (equipped.isEmpty()) {
            player.setItemSlot(slot, heldItem.copy());
            if (!level.isClientSide()) {
                player.awardStat(Stats.ITEM_USED.get((Object)this));
            }
            heldItem.setCount(0);
            return InteractionResultHolder.sidedSuccess((Object)heldItem, (boolean)level.isClientSide());
        }
        return InteractionResultHolder.fail((Object)heldItem);
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return ElytraItem.isFlyEnabled((ItemStack)stack);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        int nextFlightTick;
        if (!entity.level().isClientSide && (nextFlightTick = flightTicks + 1) % 10 == 0) {
            int itemDamage;
            double speed = entity.getDeltaMovement().length();
            int n = itemDamage = speed > 1.5 ? 3 : 1;
            if (itemDamage > 1 && entity instanceof Player) {
                Player player = (Player)entity;
                player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.glider.too_fast"), true);
            }
            if (itemDamage > 1 && (nextFlightTick + 40) % 60 == 0) {
                entity.level().playSound(null, (Entity)entity, (SoundEvent)IESounds.glider.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (nextFlightTick % 20 == 0) {
                stack.hurtAndBreak(itemDamage, entity, e -> e.broadcastBreakEvent(EquipmentSlot.CHEST));
                if (itemDamage > 1 && !ElytraItem.isFlyEnabled((ItemStack)stack)) {
                    stack.hurtAndBreak(1, entity, e -> e.broadcastBreakEvent(EquipmentSlot.CHEST));
                }
            }
            entity.gameEvent(GameEvent.ELYTRA_GLIDE);
        }
        return true;
    }

    public EquipmentSlot getEquipmentSlot(ItemStack stack) {
        return EquipmentSlot.CHEST;
    }

    @NotNull
    public EquipmentSlot getEquipmentSlot() {
        return EquipmentSlot.CHEST;
    }
}

