/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockAdvancementTrigger;
import blusunrize.immersiveengineering.api.multiblocks.MultiblockHandler;
import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.orientation.RotationUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.Tags;

public class HammerItem
extends IEBaseItem {
    public HammerItem() {
        super(new Item.Properties().defaultDurability(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return IEServerConfig.getOrDefault(IEServerConfig.TOOLS.hammerDurabiliy);
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        this.addInfo(tooltip, "desc.immersiveengineering.info.multiblocksAllowed", stack, "multiblockPermission");
        this.addInfo(tooltip, "desc.immersiveengineering.info.multiblockForbidden", stack, "multiblockInterdiction");
    }

    private void addInfo(List<Component> list, String titleKey, ItemStack stack, String nbtKey) {
        if (!ItemNBTHelper.hasKey(stack, nbtKey, 9)) {
            return;
        }
        MutableComponent title = Component.translatable((String)titleKey);
        ListTag tagList = stack.getOrCreateTag().getList(nbtKey, 8);
        if (!Screen.hasShiftDown()) {
            list.add((Component)title.append(" ").append((Component)Component.translatable((String)"desc.immersiveengineering.info.holdShift")));
        } else {
            list.add((Component)title);
            for (int i = 0; i < tagList.size(); ++i) {
                MultiblockHandler.IMultiblock multiblock;
                ResourceLocation mbName = ResourceLocation.tryParse((String)tagList.getString(i));
                if (mbName == null || (multiblock = MultiblockHandler.getByUniqueName(mbName)) == null) continue;
                list.add((Component)TextUtils.applyFormat(multiblock.getDisplayName(), ChatFormatting.DARK_GRAY));
            }
        }
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        IEBlockInterfaces.IHammerInteraction hammerInteraction;
        boolean rotate;
        ListTag list;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        Direction side = context.getClickedFace();
        List<ResourceLocation> permittedMultiblocks = null;
        List<ResourceLocation> interdictedMultiblocks = null;
        if (ItemNBTHelper.hasKey(stack, "multiblockPermission") && (permittedMultiblocks = HammerItem.parseMultiblockNames(list = stack.getOrCreateTag().getList("multiblockPermission", 8), player, "permission")) == null) {
            return InteractionResult.FAIL;
        }
        if (ItemNBTHelper.hasKey(stack, "multiblockInterdiction") && (interdictedMultiblocks = HammerItem.parseMultiblockNames(list = stack.getOrCreateTag().getList("multiblockInterdiction", 8), player, "interdiction")) == null) {
            return InteractionResult.FAIL;
        }
        Direction multiblockSide = side.getAxis() == Direction.Axis.Y && player != null ? Direction.fromYRot((double)player.getYRot()).getOpposite() : side;
        for (MultiblockHandler.IMultiblock mb : MultiblockHandler.getMultiblocks()) {
            boolean isAllowed;
            if (!mb.isBlockTrigger(world.getBlockState(pos), multiblockSide, world) || !(isAllowed = permittedMultiblocks != null ? permittedMultiblocks.contains(mb.getUniqueName()) : (interdictedMultiblocks != null ? !interdictedMultiblocks.contains(mb.getUniqueName()) : true)) || MultiblockHandler.postMultiblockFormationEvent(player, mb, pos, stack).isCanceled() || !mb.createStructure(world, pos, multiblockSide, player)) continue;
            if (player instanceof ServerPlayer) {
                ServerPlayer sPlayer = (ServerPlayer)player;
                MultiblockAdvancementTrigger.INSTANCE.get().trigger(sPlayer, mb, stack);
            }
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = world.getBlockEntity(pos);
        if (tile instanceof IEBlockInterfaces.IConfigurableSides) {
            Direction activeSide;
            IEBlockInterfaces.IConfigurableSides sideConfig = (IEBlockInterfaces.IConfigurableSides)tile;
            Direction direction = activeSide = player != null && player.isShiftKeyDown() ? side.getOpposite() : side;
            if (sideConfig.toggleSide(activeSide, player)) {
                return InteractionResult.SUCCESS;
            }
            return InteractionResult.FAIL;
        }
        Block activeSide = world.getBlockState(pos).getBlock();
        if (activeSide instanceof IEBlockInterfaces.IHammerBlockInteraction) {
            IEBlockInterfaces.IHammerBlockInteraction block = (IEBlockInterfaces.IHammerBlockInteraction)activeSide;
            return block.useHammer(world.getBlockState(pos), world, pos, player);
        }
        boolean bl = rotate = !(tile instanceof IEBlockInterfaces.IDirectionalBE) && !(tile instanceof IEBlockInterfaces.IHammerInteraction);
        if (!rotate && tile instanceof IEBlockInterfaces.IDirectionalBE) {
            IEBlockInterfaces.IDirectionalBE dirBE = (IEBlockInterfaces.IDirectionalBE)tile;
            rotate = dirBE.canHammerRotate(side, context.getClickLocation().subtract(Vec3.atLowerCornerOf((Vec3i)pos)), (LivingEntity)player);
        }
        if (rotate && RotationUtil.rotateBlock(world, pos, player != null && player.isShiftKeyDown() != side.equals((Object)Direction.DOWN))) {
            return InteractionResult.SUCCESS;
        }
        if (!rotate && tile instanceof IEBlockInterfaces.IHammerInteraction && (hammerInteraction = (IEBlockInterfaces.IHammerInteraction)tile).hammerUseSide(side, player, context.getHand(), context.getClickLocation())) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Nullable
    private static List<ResourceLocation> parseMultiblockNames(ListTag data, @Nullable Player player, String prefix) {
        ArrayList<ResourceLocation> result = new ArrayList<ResourceLocation>();
        for (int i = 0; i < data.size(); ++i) {
            String listEntry = data.getString(i);
            ResourceLocation asRL = ResourceLocation.tryParse((String)listEntry);
            if (asRL == null || MultiblockHandler.getByUniqueName(asRL) == null) {
                if (player != null && !player.getCommandSenderWorld().isClientSide) {
                    player.displayClientMessage((Component)Component.literal((String)("Invalid " + prefix + " entry: " + listEntry)), false);
                }
                return null;
            }
            result.add(asRL);
        }
        return result;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.copy();
        if (container.hurt(1, ApiUtils.RANDOM_SOURCE, null)) {
            return ItemStack.EMPTY;
        }
        return container;
    }

    public boolean hasCraftingRemainingItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 14;
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return EnchantmentHelper.getEnchantments((ItemStack)book).keySet().stream().allMatch(enchantment -> this.canApplyAtEnchantingTable(stack, (Enchantment)enchantment));
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.BLOCK_EFFICIENCY || enchantment == Enchantments.UNBREAKING || enchantment == Enchantments.MENDING;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Tags.Items.INGOTS_IRON);
    }

    public InteractionResult interactLivingEntity(ItemStack stack, Player player, LivingEntity entity, InteractionHand hand) {
        if (!player.level().isClientSide && RotationUtil.rotateEntity((Entity)entity, player)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.isCorrectToolForDrops(stack, state)) {
            return 6.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(IETags.hammerHarvestable);
    }
}

