/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.inventory.IEItemStackHandler;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.attachment.IAttachmentHolder;
import net.neoforged.neoforge.attachment.IAttachmentSerializer;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;

public abstract class InternalStorageItem
extends IEBaseItem {
    public static final IAttachmentSerializer<CompoundTag, IEItemStackHandler> DATA_SERIALIZER = new IAttachmentSerializer<CompoundTag, IEItemStackHandler>(){

        public IEItemStackHandler read(IAttachmentHolder holder, CompoundTag tag) {
            if (tag.isEmpty()) {
                return null;
            }
            IEItemStackHandler result = new IEItemStackHandler();
            result.deserializeNBT(tag);
            return result;
        }

        public CompoundTag write(IEItemStackHandler attachment) {
            if (attachment == null) {
                return new CompoundTag();
            }
            return attachment.serializeNBT();
        }
    };

    public InternalStorageItem(Item.Properties props) {
        super(props);
    }

    public abstract int getSlotCount();

    public static void registerCapabilitiesISI(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        registrar.register(Capabilities.ItemHandler.ITEM, stack -> {
            IEItemStackHandler inventory;
            AttachmentType<IEItemStackHandler> key = IEDataAttachments.ITEM_INVENTORY.get();
            InternalStorageItem item = (InternalStorageItem)stack.getItem();
            if (!stack.hasData(key)) {
                stack.setData(key, (Object)new IEItemStackHandler(item, null));
            }
            if ((inventory = (IEItemStackHandler)((Object)((Object)stack.getData(key)))).getSlots() != item.getSlotCount()) {
                inventory = new IEItemStackHandler(item, inventory);
                stack.setData(key, (Object)inventory);
            }
            return inventory;
        });
    }

    public void setContainedItems(ItemStack stack, NonNullList<ItemStack> inventory) {
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler instanceof IItemHandlerModifiable) {
            IItemHandlerModifiable modifiable = (IItemHandlerModifiable)handler;
            if (inventory.size() != modifiable.getSlots()) {
                throw new IllegalArgumentException("Parameter inventory has " + inventory.size() + " slots, capability inventory has " + modifiable.getSlots());
            }
            for (int i = 0; i < modifiable.getSlots(); ++i) {
                modifiable.setStackInSlot(i, (ItemStack)inventory.get(i));
            }
        } else {
            IELogger.warn("No valid inventory handler found for " + stack);
        }
    }

    public NonNullList<ItemStack> getContainedItems(ItemStack stack) {
        IItemHandler handler = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (handler != null) {
            if (handler instanceof IEItemStackHandler) {
                IEItemStackHandler ieHandler = (IEItemStackHandler)handler;
                return ieHandler.getContainedItems();
            }
            IELogger.warn("Inefficiently getting contained items. Why does " + stack + " have a non-IE IItemHandler?");
            NonNullList inv = NonNullList.withSize((int)handler.getSlots(), (Object)ItemStack.EMPTY);
            for (int i = 0; i < handler.getSlots(); ++i) {
                inv.set(i, (Object)handler.getStackInSlot(i));
            }
            return inv;
        }
        return NonNullList.create();
    }
}

