/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.fluids.IEItemFluidHandler;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidUtil;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;

public class JerrycanItem
extends IEBaseItem {
    private static final int jerrycanMaxMB = 10000;

    public JerrycanItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        Optional fsCap = FluidUtil.getFluidContained((ItemStack)stack);
        fsCap.ifPresent(fs -> list.add(IEItemFluidHandler.fluidItemInfoFlavor(fs, 10000)));
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext ctx) {
        Optional fs;
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ItemStack stack = ctx.getItemInHand();
        if (world.getCapability(Capabilities.FluidHandler.BLOCK, pos, null) == null && (fs = FluidUtil.getFluidContained((ItemStack)stack)).isPresent() && Utils.placeFluidBlock(world, pos.relative(ctx.getClickedFace()), (FluidStack)fs.get())) {
            ItemNBTHelper.setFluidStack(stack, "Fluid", (FluidStack)fs.get());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return ItemNBTHelper.hasKey(stack, "jerrycanDrain") || FluidUtil.getFluidContained((ItemStack)stack).isPresent();
    }

    public ItemStack getCraftingRemainingItem(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, "jerrycanDrain")) {
            ItemStack ret = stack.copy();
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)ret).orElseThrow(RuntimeException::new);
            handler.drain(ItemNBTHelper.getInt(ret, "jerrycanDrain"), IFluidHandler.FluidAction.EXECUTE);
            ItemNBTHelper.remove(ret, "jerrycanDrain");
            return ret;
        }
        if (FluidUtil.getFluidContained((ItemStack)stack).isPresent()) {
            ItemStack ret = stack.copy();
            IFluidHandler handler = (IFluidHandler)FluidUtil.getFluidHandler((ItemStack)ret).orElseThrow(RuntimeException::new);
            handler.drain(1000, IFluidHandler.FluidAction.EXECUTE);
            return ret;
        }
        return stack;
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        registrar.register(Capabilities.FluidHandler.ITEM, (stack, $) -> new FluidHandlerItemStack(stack, 10000));
    }
}

