/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.common.fluids.PotionFluid;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.register.IEItems;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.event.EventHooks;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.IFluidHandlerItem;

public class PotionBucketItem
extends IEBaseItem {
    public PotionBucketItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public static ItemStack forPotion(Potion type) {
        if (type == Potions.WATER || type == null) {
            return new ItemStack((ItemLike)Items.WATER_BUCKET);
        }
        ItemStack result = new ItemStack(IEItems.Misc.POTION_BUCKET);
        result.getOrCreateTag().putString("Potion", BuiltInRegistries.POTION.getKey((Object)type).toString());
        return result;
    }

    public static Potion getPotion(ItemStack stack) {
        return PotionFluid.fromTag(stack.getTag());
    }

    @Override
    public void fillCreativeTab(CreativeModeTab.Output out) {
        List<Potion> sortedPotions = BuiltInRegistries.POTION.stream().sorted(Comparator.comparing(e -> PotionBucketItem.getPotionName(e).getString())).toList();
        for (Potion p : sortedPotions) {
            if (p == Potions.WATER || p == Potions.EMPTY) continue;
            out.accept(PotionBucketItem.forPotion(p));
        }
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        registrar.register(Capabilities.FluidHandler.ITEM, (stack, $) -> new FluidHandler((ItemStack)stack));
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        return Component.translatable((String)"item.immersiveengineering.potion_bucket", (Object[])new Object[]{PotionBucketItem.getPotionName(PotionBucketItem.getPotion(stack))});
    }

    private static Component getPotionName(Potion potion) {
        String potionKey = potion.getName(Items.POTION.getDescriptionId() + ".effect.");
        return Component.translatable((String)potionKey);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(@Nonnull Level worldIn, @Nonnull Player playerIn, @Nonnull InteractionHand handIn) {
        BlockHitResult rayTraceResult = PotionBucketItem.getPlayerPOVHitResult((Level)worldIn, (Player)playerIn, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        ItemStack stack = playerIn.getItemInHand(handIn);
        InteractionResultHolder forgeResult = EventHooks.onBucketUse((Player)playerIn, (Level)worldIn, (ItemStack)stack, (HitResult)rayTraceResult);
        if (forgeResult != null) {
            return forgeResult;
        }
        return InteractionResultHolder.pass((Object)stack);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Level worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        PotionUtils.addPotionTooltip((ItemStack)stack, tooltip, (float)1.0f, (float)(worldIn == null ? 20.0f : worldIn.tickRateManager().tickrate()));
    }

    private static class FluidHandler
    implements IFluidHandlerItem {
        private final ItemStack stack;
        private boolean empty = false;

        private FluidHandler(ItemStack stack) {
            this.stack = stack;
        }

        private FluidStack getFluid() {
            if (this.empty) {
                return FluidStack.EMPTY;
            }
            return PotionFluid.getFluidStackForType(PotionBucketItem.getPotion(this.stack), 1000);
        }

        @Nonnull
        public ItemStack getContainer() {
            return this.empty ? new ItemStack((ItemLike)Items.BUCKET) : this.stack;
        }

        public int getTanks() {
            return 1;
        }

        @Nonnull
        public FluidStack getFluidInTank(int tank) {
            if (tank == 0) {
                return this.getFluid();
            }
            return FluidStack.EMPTY;
        }

        public int getTankCapacity(int tank) {
            return tank == 0 ? 1000 : 0;
        }

        public boolean isFluidValid(int tank, @Nonnull FluidStack stack) {
            return false;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            return 0;
        }

        @Nonnull
        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            FluidStack fluid = this.getFluid();
            if (!fluid.isFluidEqual(resource) || !Objects.equals(fluid.getTag(), resource.getTag())) {
                return FluidStack.EMPTY;
            }
            return this.drain(resource.getAmount(), action);
        }

        @Nonnull
        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.empty || this.stack.getCount() > 1 || maxDrain < 1000) {
                return FluidStack.EMPTY;
            }
            FluidStack potion = this.getFluid();
            if (action.execute()) {
                this.empty = true;
            }
            return potion;
        }
    }
}

