/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.entities.RailgunShotEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.util.EnergyHelper;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.items.IItemHandler;

public class RailgunItem
extends UpgradeableToolItem
implements ZoomHandler.IZoomTool,
IEItemInterfaces.IScrollwheel {
    float[] zoomSteps = new float[]{0.1f, 0.15625f, 0.2f, 0.25f, 0.3125f, 0.4f, 0.5f, 0.625f};

    public RailgunItem() {
        super(new Item.Properties().stacksTo(1), "RAILGUN");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    @Override
    public int getSlotCount() {
        return 3;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 80, 32, "RAILGUN", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 100, 32, "RAILGUN", stack, true, level, getPlayer)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void recalculateUpgrades(ItemStack stack, Level w, Player player) {
        super.recalculateUpgrades(stack, w, player);
        IEnergyStorage energy = Objects.requireNonNull((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM));
        if (energy.getEnergyStored() > RailgunItem.getMaxEnergyStored(stack)) {
            ItemNBTHelper.putInt(stack, "energy", RailgunItem.getMaxEnergyStored(stack));
        }
    }

    @Override
    public void clearUpgrades(ItemStack stack) {
        super.clearUpgrades(stack);
        IEnergyStorage energy = Objects.requireNonNull((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM));
        if (energy.getEnergyStored() > RailgunItem.getMaxEnergyStored(stack)) {
            ItemNBTHelper.putInt(stack, "energy", RailgunItem.getMaxEnergyStored(stack));
        }
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged || CapabilityShader.shouldReequipDueToShader(oldStack, newStack)) {
            return true;
        }
        return super.shouldCauseReequipAnimation(oldStack, newStack, slotChanged);
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        RailgunItem.registerCapabilitiesISI(registrar);
        registrar.register(Capabilities.EnergyStorage.ITEM, stack -> new EnergyHelper.ItemEnergyStorage((ItemStack)stack, RailgunItem::getMaxEnergyStored));
        registrar.register(CapabilityShader.ITEM, stack -> new CapabilityShader.ShaderWrapper_Item(new ResourceLocation("immersiveengineering", "railgun"), (ItemStack)stack));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        IEnergyStorage energy = Objects.requireNonNull((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM));
        String stored = energy.getEnergyStored() + "/" + RailgunItem.getMaxEnergyStored(stack);
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.energyStored", (Object[])new Object[]{stored}).withStyle(ChatFormatting.GRAY));
    }

    @Nonnull
    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.NONE;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        int consumption = (Integer)IEServerConfig.TOOLS.railgun_consumption.get();
        float energyMod = 1.0f + this.getUpgrades(stack).getFloat("consumption");
        consumption = (int)((float)consumption * energyMod);
        IEnergyStorage energy = Objects.requireNonNull((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM));
        if (energy.extractEnergy(consumption, true) == consumption && !RailgunItem.findAmmo(stack, player).isEmpty()) {
            player.startUsingItem(hand);
            RailgunItem.playChargeSound((LivingEntity)player, stack);
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public static void playChargeSound(LivingEntity living, ItemStack railgun) {
        living.level().playSound(null, living.getX(), living.getY(), living.getZ(), RailgunItem.getChargeTime(railgun) <= 20 ? (SoundEvent)IESounds.chargeFast.value() : (SoundEvent)IESounds.chargeSlow.value(), SoundSource.PLAYERS, 1.5f, 1.0f);
    }

    public void onUseTick(Level level, LivingEntity user, ItemStack stack, int count) {
        int inUse = this.getUseDuration(stack) - count;
        if (inUse > RailgunItem.getChargeTime(stack) && inUse % 20 == user.getRandom().nextInt(20)) {
            user.level().playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)IESounds.spark.value(), SoundSource.PLAYERS, 0.8f + 0.2f * user.getRandom().nextFloat(), 0.5f + 0.5f * user.getRandom().nextFloat());
            ShaderRegistry.ShaderAndCase shader = ShaderRegistry.getStoredShaderAndCase(stack);
            if (shader != null) {
                Vec3 pos = Utils.getLivingFrontPos(user, 0.4375, (double)user.getBbHeight() * 0.75, ItemUtils.getLivingHand(user, user.getUsedItemHand()), false, 1.0f);
                shader.registryEntry().getEffectFunction().execute(user.level(), shader.shader(), stack, shader.sCase().getShaderType().toString(), pos, null, 0.0625f);
            }
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity user, int timeLeft) {
        if (!world.isClientSide() && user instanceof Player) {
            ItemStack ammo;
            Player player = (Player)user;
            int inUse = this.getUseDuration(stack) - timeLeft;
            ItemNBTHelper.remove(stack, "inUse");
            if (inUse < RailgunItem.getChargeTime(stack)) {
                return;
            }
            int consumption = (Integer)IEServerConfig.TOOLS.railgun_consumption.get();
            float energyMod = 1.0f + this.getUpgrades(stack).getFloat("consumption");
            consumption = (int)((float)consumption * energyMod);
            IEnergyStorage energy = Objects.requireNonNull((IEnergyStorage)stack.getCapability(Capabilities.EnergyStorage.ITEM));
            if (energy.extractEnergy(consumption, true) == consumption && !(ammo = RailgunItem.findAmmo(stack, player)).isEmpty()) {
                ItemStack ammoConsumed = ammo.split(1);
                RailgunItem.fireProjectile(stack, world, user, ammoConsumed);
                energy.extractEnergy(consumption, false);
            }
        }
    }

    public static Entity fireProjectile(ItemStack railgun, Level world, LivingEntity user, ItemStack ammo) {
        ShaderRegistry.ShaderAndCase shader;
        Player player;
        RailgunHandler.IRailgunProjectile projectileProperties = RailgunHandler.getProjectile(ammo);
        float speed = 20.0f;
        RailgunShotEntity shot = new RailgunShotEntity(user.level(), user, speed, 0.0f, ammo);
        shot = projectileProperties.getProjectile(user instanceof Player ? (player = (Player)user) : null, ammo, (Entity)shot);
        user.level().playSound(null, user.getX(), user.getY(), user.getZ(), (SoundEvent)IESounds.railgunFire.value(), SoundSource.PLAYERS, 1.0f, 0.5f + 0.5f * user.getRandom().nextFloat());
        if (!world.isClientSide) {
            user.level().addFreshEntity((Entity)shot);
        }
        if ((shader = ShaderRegistry.getStoredShaderAndCase(railgun)) != null) {
            HumanoidArm handside = user.getMainArm();
            if (user.getUsedItemHand() != InteractionHand.MAIN_HAND) {
                handside = handside == HumanoidArm.LEFT ? HumanoidArm.RIGHT : HumanoidArm.LEFT;
            }
            Vec3 pos = Utils.getLivingFrontPos(user, 0.75, (double)user.getBbHeight() * 0.75, handside, false, 1.0f);
            shader.registryEntry().getEffectFunction().execute(world, shader.shader(), railgun, shader.sCase().getShaderType().toString(), pos, Vec3.directionFromRotation((Vec2)user.getRotationVector()), 0.125f);
        }
        return shot;
    }

    public static ItemStack findAmmo(ItemStack railgun, Player player) {
        int slot;
        ItemStack ammo;
        if (ItemNBTHelper.hasKey(railgun, "ammo_slot") && !(ammo = RailgunItem.findAmmoInSlot(player, slot = ItemNBTHelper.getInt(railgun, "ammo_slot"))).isEmpty()) {
            return ammo;
        }
        if (RailgunItem.isAmmo(player.getItemInHand(InteractionHand.OFF_HAND))) {
            ItemNBTHelper.putInt(railgun, "ammo_slot", 0);
            return player.getItemInHand(InteractionHand.OFF_HAND);
        }
        if (RailgunItem.isAmmo(player.getItemInHand(InteractionHand.MAIN_HAND))) {
            ItemNBTHelper.putInt(railgun, "ammo_slot", 1);
            return player.getItemInHand(InteractionHand.MAIN_HAND);
        }
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack itemstack = player.getInventory().getItem(i);
            if (!RailgunItem.isAmmo(itemstack)) continue;
            ItemNBTHelper.putInt(railgun, "ammo_slot", 2 + i);
            return itemstack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack findAmmoInSlot(Player player, int slot) {
        ItemStack ammo = ItemStack.EMPTY;
        if (slot == 0 || slot == 1) {
            ammo = player.getItemInHand(slot == 0 ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND);
        } else if (slot > 1 && slot - 2 < player.getInventory().getContainerSize()) {
            ammo = player.getInventory().getItem(slot - 2);
        }
        if (RailgunItem.isAmmo(ammo)) {
            return ammo;
        }
        return ItemStack.EMPTY;
    }

    public static boolean isAmmo(ItemStack stack) {
        if (stack.isEmpty()) {
            return false;
        }
        RailgunHandler.IRailgunProjectile prop = RailgunHandler.getProjectile(stack);
        return prop != null;
    }

    private boolean checkAmmoSlot(ItemStack stack, Player player, int actualSlot) {
        if (!RailgunItem.findAmmoInSlot(player, actualSlot).isEmpty()) {
            ItemNBTHelper.putInt(stack, "ammo_slot", actualSlot);
            player.getInventory().setChanged();
            return true;
        }
        return false;
    }

    @Override
    public void onScrollwheel(ItemStack stack, Player player, boolean forward) {
        int slot = ItemNBTHelper.getInt(stack, "ammo_slot");
        int count = player.getInventory().getContainerSize() + 2;
        if (forward) {
            for (int i = 1; i < count; ++i) {
                if (!this.checkAmmoSlot(stack, player, (slot + i) % count)) continue;
                return;
            }
        } else {
            for (int i = count - 1; i >= 1; --i) {
                if (!this.checkAmmoSlot(stack, player, (slot + i) % count)) continue;
                return;
            }
        }
    }

    public static int getChargeTime(ItemStack railgun) {
        return (int)(40.0f / (1.0f + RailgunItem.getUpgradesStatic(railgun).getFloat("speed")));
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (inv != null && !inv.getStackInSlot(0).isEmpty() && !inv.getStackInSlot(1).isEmpty()) {
            Utils.unlockIEAdvancement(player, "tools/upgrade_railgun");
        }
    }

    public static int getMaxEnergyStored(ItemStack container) {
        return 8000;
    }

    @Override
    public boolean canZoom(ItemStack stack, Player player) {
        return this.getUpgrades(stack).getBoolean("scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, Player player) {
        return this.zoomSteps;
    }
}

