/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.client.ieobj.ItemCallback;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.tool.BulletHandler;
import blusunrize.immersiveengineering.api.tool.ZoomHandler;
import blusunrize.immersiveengineering.api.utils.ItemUtils;
import blusunrize.immersiveengineering.client.render.tooltip.RevolverServerTooltip;
import blusunrize.immersiveengineering.common.entities.RevolvershotEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.BulletItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.items.InternalStorageItem;
import blusunrize.immersiveengineering.common.items.ItemCapabilityRegistration;
import blusunrize.immersiveengineering.common.items.SpeedloaderItem;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.network.MessageSpeedloaderSync;
import blusunrize.immersiveengineering.common.register.IEMenuTypes;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.ListUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoublePredicate;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.extensions.common.IClientItemExtensions;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.network.PacketDistributor;

public class RevolverItem
extends UpgradeableToolItem
implements IEItemInterfaces.IBulletContainer,
ZoomHandler.IZoomTool {
    public static UUID speedModUUID = Utils.generateNewUUID();
    public static UUID luckModUUID = Utils.generateNewUUID();
    float[] zoomSteps = new float[]{0.3125f, 0.4f, 0.5f, 0.625f};
    public static final Multimap<String, SpecialRevolver> specialRevolvers = ArrayListMultimap.create();
    public static final Map<String, SpecialRevolver> specialRevolversByTag = new HashMap<String, SpecialRevolver>();

    public RevolverItem() {
        super(new Item.Properties().stacksTo(1), "REVOLVER");
    }

    public void initializeClient(@Nonnull Consumer<IClientItemExtensions> consumer) {
        super.initializeClient(consumer);
        consumer.accept(ItemCallback.USE_IEOBJ_RENDER);
    }

    public static void registerCapabilities(ItemCapabilityRegistration.ItemCapabilityRegistrar registrar) {
        registrar.register(CapabilityShader.ITEM, stack -> new CapabilityShader.ShaderWrapper_Item(IEApi.ieLoc("revolver"), (ItemStack)stack));
        InternalStorageItem.registerCapabilitiesISI(registrar);
    }

    @Override
    public int getSlotCount() {
        return 21;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 18, 80, 32, "REVOLVER", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 19, 100, 32, "REVOLVER", stack, true, level, getPlayer)};
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public void removeFromWorkbench(Player player, ItemStack stack) {
        IItemHandler inv = (IItemHandler)stack.getCapability(Capabilities.ItemHandler.ITEM);
        if (inv != null && !inv.getStackInSlot(18).isEmpty() && !inv.getStackInSlot(19).isEmpty()) {
            Utils.unlockIEAdvancement(player, "tools/upgrade_revolver");
        }
    }

    @Nonnull
    public String getDescriptionId(@Nonnull ItemStack stack) {
        String tag = this.getRevolverDisplayTag(stack);
        if (!tag.isEmpty()) {
            return this.getDescriptionId() + "." + tag;
        }
        return super.getDescriptionId(stack);
    }

    public void appendHoverText(@Nonnull ItemStack stack, @Nullable Level world, @Nonnull List<Component> list, @Nonnull TooltipFlag flag) {
        String tag = this.getRevolverDisplayTag(stack);
        if (!tag.isEmpty()) {
            list.add((Component)Component.translatable((String)("desc.immersiveengineering.flavour.revolver." + tag)).withStyle(ChatFormatting.GRAY));
        } else if (ItemNBTHelper.hasKey(stack, "flavour")) {
            list.add((Component)Component.translatable((String)("desc.immersiveengineering.flavour.revolver." + ItemNBTHelper.getString(stack, "flavour"))).withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.revolver").withStyle(ChatFormatting.GRAY));
        }
        CompoundTag perks = RevolverItem.getPerks(stack);
        for (String key : perks.getAllKeys()) {
            RevolverPerk perk = RevolverPerk.get(key);
            if (perk == null) continue;
            list.add((Component)Component.literal((String)"  ").append(perk.getDisplayString(perks.getDouble(key))));
        }
    }

    @Nonnull
    public Optional<TooltipComponent> getTooltipImage(@Nonnull ItemStack pStack) {
        return Optional.of(new RevolverServerTooltip(this.getBullets(pStack), this.getBulletCount(pStack)));
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(@Nonnull EquipmentSlot slot, ItemStack stack) {
        double luck;
        double speed;
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND) {
            double melee;
            if (this.getUpgrades(stack).getBoolean("fancyAnimation")) {
                builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", -2.0, AttributeModifier.Operation.ADDITION));
            }
            if ((melee = RevolverItem.getUpgradeValue_d(stack, "melee")) != 0.0) {
                builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", melee, AttributeModifier.Operation.ADDITION));
                builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
            }
        }
        if (slot.getType() == EquipmentSlot.Type.HAND && (speed = RevolverItem.getUpgradeValue_d(stack, "speed")) != 0.0) {
            builder.put((Object)Attributes.MOVEMENT_SPEED, (Object)new AttributeModifier(speedModUUID, "Weapon modifier", speed, AttributeModifier.Operation.MULTIPLY_BASE));
        }
        if ((luck = RevolverItem.getUpgradeValue_d(stack, RevolverPerk.LUCK.getNBTKey())) != 0.0) {
            builder.put((Object)Attributes.LUCK, (Object)new AttributeModifier(luckModUUID, "Weapon modifier", luck, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    public void inventoryTick(@Nonnull ItemStack stack, @Nonnull Level world, @Nonnull Entity ent, int slot, boolean inHand) {
        super.inventoryTick(stack, world, ent, slot, inHand);
        if (ItemNBTHelper.hasKey(stack, "reload")) {
            int reload = ItemNBTHelper.getInt(stack, "reload") - 1;
            if (reload <= 0) {
                ItemNBTHelper.remove(stack, "reload");
            } else {
                ItemNBTHelper.putInt(stack, "reload", reload);
            }
        }
    }

    @Nonnull
    public UseAnim getUseAnimation(@Nonnull ItemStack stack) {
        return UseAnim.BOW;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack revolver = player.getItemInHand(hand);
        if (player.isShiftKeyDown()) {
            this.openGui(player, hand);
            return InteractionResultHolder.sidedSuccess((Object)revolver, (boolean)world.isClientSide());
        }
        if (player.getAttackStrengthScale(1.0f) < 1.0f) {
            return InteractionResultHolder.pass((Object)revolver);
        }
        if (this.getUpgrades(revolver).getBoolean("nerf")) {
            world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.ITEM_PICKUP, SoundSource.PLAYERS, 1.0f, 0.6f);
            return InteractionResultHolder.sidedSuccess((Object)revolver, (boolean)world.isClientSide());
        }
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return InteractionResultHolder.pass((Object)revolver);
        }
        NonNullList<ItemStack> bullets = this.getBullets(revolver);
        if (bullets.stream().noneMatch(stack -> stack.getItem() instanceof BulletItem) && this.useSpeedloader(world, player, revolver, hand, bullets)) {
            return InteractionResultHolder.sidedSuccess((Object)revolver, (boolean)world.isClientSide());
        }
        ItemStack bulletStack = (ItemStack)bullets.get(0);
        Item bullet0 = bulletStack.getItem();
        if (bullet0 instanceof BulletItem) {
            BulletHandler.IBullet bullet = ((BulletItem)bullet0).getType();
            if (bullet != null) {
                if (!world.isClientSide()) {
                    ShaderRegistry.ShaderAndCase shader;
                    float noise = RevolverItem.fireProjectile(world, (LivingEntity)player, revolver, bullet, bulletStack);
                    bullets.set(0, (Object)bullet.getCasing((ItemStack)bullets.get(0)).copy());
                    Utils.attractEnemies((LivingEntity)player, 64.0f * noise);
                    if (noise > 0.2f) {
                        GameEvent eventTriggered = (double)noise > 0.5 ? GameEvent.EXPLODE : GameEvent.PROJECTILE_SHOOT;
                        player.gameEvent(eventTriggered);
                    }
                    if ((shader = ShaderRegistry.getStoredShaderAndCase(revolver)) != null) {
                        Vec3 pos = Utils.getLivingFrontPos((LivingEntity)player, 0.75, (double)player.getBbHeight() * 0.75, ItemUtils.getLivingHand((LivingEntity)player, hand), false, 1.0f);
                        shader.registryEntry().getEffectFunction().execute(world, shader.shader(), revolver, shader.sCase().getShaderType().toString(), pos, Vec3.directionFromRotation((Vec2)player.getRotationVector()), 0.125f);
                    }
                }
            } else {
                world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            world.playSound(null, player.getX(), player.getY(), player.getZ(), (SoundEvent)SoundEvents.NOTE_BLOCK_HAT.value(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        this.rotateCylinder(revolver, player, true, bullets);
        player.getCooldowns().addCooldown((Item)this, this.getMaxShootCooldown(revolver));
        return InteractionResultHolder.sidedSuccess((Object)revolver, (boolean)world.isClientSide());
    }

    public boolean useSpeedloader(Level level, Player player, ItemStack revolver, InteractionHand hand, NonNullList<ItemStack> bullets) {
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            ItemStack stack = player.getInventory().getItem(i);
            if (!(stack.getItem() instanceof SpeedloaderItem) || ((SpeedloaderItem)stack.getItem()).isEmpty(stack)) continue;
            if (!level.isClientSide()) {
                for (ItemStack b : bullets) {
                    if (b.isEmpty()) continue;
                    level.addFreshEntity((Entity)new ItemEntity(level, player.getX(), player.getY(), player.getZ(), b));
                }
                this.setBullets(revolver, ((SpeedloaderItem)stack.getItem()).getContainedItems(stack), true);
                ((SpeedloaderItem)stack.getItem()).setContainedItems(stack, (NonNullList<ItemStack>)NonNullList.withSize((int)8, (Object)ItemStack.EMPTY));
                player.getInventory().setChanged();
                if (player instanceof ServerPlayer) {
                    PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)).send(new CustomPacketPayload[]{new MessageSpeedloaderSync(i, hand)});
                }
            }
            ItemNBTHelper.putInt(revolver, "reload", 60);
            player.getCooldowns().addCooldown((Item)this, 60);
            return true;
        }
        return false;
    }

    public static float fireProjectile(Level world, LivingEntity shooter, ItemStack revolver, BulletHandler.IBullet bullet, ItemStack bulletStack) {
        SoundEvent sound;
        Player p;
        Player player = shooter instanceof Player ? (p = (Player)shooter) : null;
        Vec3 vec = shooter.getLookAngle();
        boolean electro = RevolverItem.getUpgradesStatic(revolver).getBoolean("electro");
        int count = bullet.getProjectileCount(player);
        if (count == 1) {
            RevolvershotEntity entBullet = RevolverItem.getBullet(shooter, vec, bullet, electro);
            shooter.level().addFreshEntity(bullet.getProjectile(player, bulletStack, (Entity)entBullet, electro));
        } else {
            for (int i = 0; i < count; ++i) {
                Vec3 vecDir = vec.add(shooter.getRandom().nextGaussian() * 0.1, shooter.getRandom().nextGaussian() * 0.1, shooter.getRandom().nextGaussian() * 0.1);
                RevolvershotEntity entBullet = RevolverItem.getBullet(shooter, vecDir, bullet, electro);
                shooter.level().addFreshEntity(bullet.getProjectile(player, bulletStack, (Entity)entBullet, electro));
            }
        }
        float noise = 0.5f;
        if (RevolverItem.hasUpgradeValue(revolver, RevolverPerk.NOISE.getNBTKey())) {
            noise *= (float)RevolverItem.getUpgradeValue_d(revolver, RevolverPerk.NOISE.getNBTKey());
        }
        if ((sound = bullet.getSound()) == null) {
            sound = (SoundEvent)IESounds.revolverFire.value();
        }
        world.playSound(null, shooter.getX(), shooter.getY(), shooter.getZ(), sound, SoundSource.PLAYERS, noise, 1.0f);
        return noise;
    }

    public int getMaxShootCooldown(ItemStack stack) {
        if (RevolverItem.hasUpgradeValue(stack, RevolverPerk.COOLDOWN.getNBTKey())) {
            return (int)Math.ceil(15.0 * RevolverItem.getUpgradeValue_d(stack, RevolverPerk.COOLDOWN.getNBTKey()));
        }
        return 15;
    }

    @Override
    public int getBulletCount(ItemStack revolver) {
        return 8 + this.getUpgrades(revolver).getInt("bullets");
    }

    @Override
    public NonNullList<ItemStack> getBullets(ItemStack revolver) {
        return ListUtils.fromItems(this.getContainedItems(revolver).subList(0, this.getBulletCount(revolver)));
    }

    private static RevolvershotEntity getBullet(LivingEntity living, Vec3 vecDir, BulletHandler.IBullet type, boolean electro) {
        RevolvershotEntity bullet = new RevolvershotEntity(living.level(), living, vecDir.x * 1.5, vecDir.y * 1.5, vecDir.z * 1.5, type);
        bullet.setDeltaMovement(vecDir.scale(2.0));
        bullet.bulletElectro = electro;
        return bullet;
    }

    public void setBullets(ItemStack revolver, NonNullList<ItemStack> bullets, boolean ignoreExtendedMag) {
        int i;
        IItemHandlerModifiable inv = (IItemHandlerModifiable)revolver.getCapability(Capabilities.ItemHandler.ITEM);
        for (i = 0; i < 18; ++i) {
            inv.setStackInSlot(i, ItemStack.EMPTY);
        }
        if (ignoreExtendedMag && this.getUpgrades(revolver).getInt("bullets") > 0) {
            for (i = 0; i < bullets.size(); ++i) {
                inv.setStackInSlot(i < 2 ? i : i + this.getUpgrades(revolver).getInt("bullets"), (ItemStack)bullets.get(i));
            }
        } else {
            for (i = 0; i < bullets.size(); ++i) {
                inv.setStackInSlot(i, (ItemStack)bullets.get(i));
            }
        }
    }

    public void rotateCylinder(ItemStack revolver, Player player, boolean forward, NonNullList<ItemStack> bullets) {
        NonNullList cycled = NonNullList.withSize((int)this.getBulletCount(revolver), (Object)ItemStack.EMPTY);
        int offset = forward ? -1 : 1;
        for (int i = 0; i < cycled.size(); ++i) {
            cycled.set((i + offset + cycled.size()) % cycled.size(), (Object)((ItemStack)bullets.get(i)));
        }
        this.setBullets(revolver, (NonNullList<ItemStack>)cycled, false);
        player.getInventory().setChanged();
    }

    public void rotateCylinder(ItemStack revolver, Player player, boolean forward) {
        NonNullList<ItemStack> bullets = this.getBullets(revolver);
        this.rotateCylinder(revolver, player, forward, bullets);
    }

    @Override
    public CompoundTag getUpgradeBase(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "baseUpgrades");
    }

    public String getRevolverDisplayTag(ItemStack revolver) {
        String tag = ItemNBTHelper.getString(revolver, "elite");
        if (!tag.isEmpty()) {
            int split = tag.lastIndexOf("_");
            if (split < 0) {
                split = tag.length();
            }
            return tag.substring(0, split);
        }
        return "";
    }

    public static CompoundTag getPerks(ItemStack stack) {
        return ItemNBTHelper.getTagCompound(stack, "perks");
    }

    public static boolean hasUpgradeValue(ItemStack stack, String key) {
        return RevolverItem.getUpgradesStatic(stack).contains(key) || RevolverItem.getPerks(stack).contains(key);
    }

    public static double getUpgradeValue_d(ItemStack stack, String key) {
        return RevolverItem.getUpgradesStatic(stack).getDouble(key) + RevolverItem.getPerks(stack).getDouble(key);
    }

    @Override
    public boolean canZoom(ItemStack stack, Player player) {
        return RevolverItem.hasUpgradeValue(stack, "scope");
    }

    @Override
    public float[] getZoomSteps(ItemStack stack, Player player) {
        return this.zoomSteps;
    }

    public void onCraftedBy(ItemStack stack, @Nonnull Level world, @Nonnull Player player) {
        ArrayList list;
        if (stack.isEmpty() || player == null) {
            return;
        }
        String uuid = player.getUUID().toString();
        if (specialRevolvers.containsKey((Object)uuid) && !(list = new ArrayList(specialRevolvers.get((Object)uuid))).isEmpty()) {
            list.add(null);
            String existingTag = ItemNBTHelper.getString(stack, "elite");
            if (existingTag.isEmpty()) {
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(0));
            } else {
                int i;
                for (i = 0; !(i >= list.size() || list.get(i) != null && existingTag.equals(((SpecialRevolver)list.get((int)i)).tag)); ++i) {
                }
                int next = (i + 1) % list.size();
                this.applySpecialCrafting(stack, (SpecialRevolver)list.get(next));
            }
        }
        this.recalculateUpgrades(stack, world, player);
    }

    public void applySpecialCrafting(ItemStack stack, SpecialRevolver r) {
        if (r == null) {
            ItemNBTHelper.remove(stack, "elite");
            ItemNBTHelper.remove(stack, "flavour");
            ItemNBTHelper.remove(stack, "baseUpgrades");
            return;
        }
        if (r.tag != null && !r.tag.isEmpty()) {
            ItemNBTHelper.putString(stack, "elite", r.tag);
        }
        if (r.flavour != null && !r.flavour.isEmpty()) {
            ItemNBTHelper.putString(stack, "flavour", r.flavour);
        }
        CompoundTag baseUpgrades = new CompoundTag();
        for (Map.Entry<String, Object> e : r.baseUpgrades.entrySet()) {
            if (e.getValue() instanceof Boolean) {
                baseUpgrades.putBoolean(e.getKey(), ((Boolean)e.getValue()).booleanValue());
                continue;
            }
            if (e.getValue() instanceof Integer) {
                baseUpgrades.putInt(e.getKey(), ((Integer)e.getValue()).intValue());
                continue;
            }
            if (e.getValue() instanceof Float) {
                baseUpgrades.putDouble(e.getKey(), (double)((Float)e.getValue()).floatValue());
                continue;
            }
            if (e.getValue() instanceof Double) {
                baseUpgrades.putDouble(e.getKey(), ((Double)e.getValue()).doubleValue());
                continue;
            }
            if (!(e.getValue() instanceof String)) continue;
            baseUpgrades.putString(e.getKey(), (String)e.getValue());
        }
        ItemNBTHelper.setTagCompound(stack, "baseUpgrades", baseUpgrades);
    }

    @Override
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        if (slotChanged || CapabilityShader.shouldReequipDueToShader(oldStack, newStack)) {
            return true;
        }
        if (ItemNBTHelper.hasKey(oldStack, "elite") || ItemNBTHelper.hasKey(newStack, "elite")) {
            return !ItemNBTHelper.getString(oldStack, "elite").equals(ItemNBTHelper.getString(newStack, "elite"));
        }
        return false;
    }

    @Override
    @Nullable
    protected IEMenuTypes.ItemContainerType<?> getContainerType() {
        return IEMenuTypes.REVOLVER;
    }

    @ParametersAreNonnullByDefault
    public static enum RevolverPerk {
        COOLDOWN(f -> f > 1.0, f -> Utils.NUMBERFORMAT_PREFIXED.format((1.0 - f) * 100.0), (l, r) -> l * r, 1.0, -0.75, -0.05),
        NOISE(f -> f > 1.0, f -> Utils.NUMBERFORMAT_PREFIXED.format((f - 1.0) * 100.0), (l, r) -> l * r, 1.0, -0.9, -0.1),
        LUCK(f -> f < 0.0, f -> Utils.NUMBERFORMAT_PREFIXED.format(f * 100.0), (l, r) -> l + r, 0.0, 3.0, 0.5);

        private final DoublePredicate isBadValue;
        private final Function<Double, String> valueFormatter;
        private final DoubleBinaryOperator valueConcat;
        private final double generate_median;
        private final double generate_deviation;
        private final double generate_luckScale;

        private RevolverPerk(DoublePredicate isBadValue, Function<Double, String> valueFormatter, DoubleBinaryOperator valueConcat, double generate_median, double generate_deviation, double generate_luckScale) {
            this.isBadValue = isBadValue;
            this.valueFormatter = valueFormatter;
            this.valueConcat = valueConcat;
            this.generate_median = generate_median;
            this.generate_deviation = generate_deviation;
            this.generate_luckScale = generate_luckScale;
        }

        public String getNBTKey() {
            return this.name().toLowerCase(Locale.US);
        }

        public Component getDisplayString(double value) {
            String key = "desc.immersiveengineering.info.revolver.perk." + this.toString();
            return Component.translatable((String)key, (Object[])new Object[]{this.valueFormatter.apply(value)}).withStyle(this.isBadValue.test(value) ? ChatFormatting.RED : ChatFormatting.BLUE);
        }

        public static Component getFormattedName(Component name, CompoundTag perksTag) {
            double averageTier = 0.0;
            for (String key : perksTag.getAllKeys()) {
                RevolverPerk perk = RevolverPerk.get(key);
                double value = perksTag.getDouble(key);
                double dTier = (value - perk.generate_median) / perk.generate_deviation * 3.0;
                averageTier += dTier;
                int iTier = (int)Mth.clamp((double)(dTier < 0.0 ? Math.floor(dTier) : Math.ceil(dTier)), (double)-3.0, (double)3.0);
                if (iTier == 0) {
                    iTier = 1;
                }
                String translate = "desc.immersiveengineering.info.revolver.perk." + perk.name().toLowerCase(Locale.US) + ".tier" + iTier;
                name = Component.translatable((String)translate, (Object[])new Object[]{name});
            }
            int rarityTier = (int)Math.ceil(Mth.clamp((double)(averageTier + 3.0), (double)0.0, (double)6.0) / 6.0 * 5.0);
            Rarity rarity = rarityTier == 5 ? Lib.RARITY_MASTERWORK : (rarityTier == 4 ? Rarity.EPIC : (rarityTier == 3 ? Rarity.RARE : (rarityTier == 2 ? Rarity.UNCOMMON : Rarity.COMMON)));
            return name.copy().withStyle(rarity.color);
        }

        public static int calculateTier(CompoundTag perksTag) {
            double averageTier = 0.0;
            for (String key : perksTag.getAllKeys()) {
                RevolverPerk perk = RevolverPerk.get(key);
                double value = perksTag.getDouble(key);
                double dTier = (value - perk.generate_median) / perk.generate_deviation * 3.0;
                averageTier += dTier;
            }
            return (int)Math.ceil(Mth.clamp((double)(averageTier + 3.0), (double)0.0, (double)6.0) / 6.0 * 5.0);
        }

        public double concat(double left, double right) {
            return this.valueConcat.applyAsDouble(left, right);
        }

        public double generateValue(RandomSource rand, boolean isBad, float luck) {
            double d = Utils.generateLuckInfluencedDouble(this.generate_median, this.generate_deviation, luck, rand, isBad, this.generate_luckScale);
            int i = (int)(d * 100.0);
            d = (double)i / 100.0;
            return d;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.US);
        }

        public static RevolverPerk get(String name) {
            try {
                return RevolverPerk.valueOf(name.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                return null;
            }
        }

        public static RevolverPerk getRandom(RandomSource rand) {
            int i = rand.nextInt(RevolverPerk.values().length);
            return RevolverPerk.values()[i];
        }

        public static CompoundTag generatePerkSet(RandomSource rand, float luck) {
            RevolverPerk goodPerk = RevolverPerk.getRandom(rand);
            RevolverPerk badPerk = LUCK;
            double val = goodPerk.generateValue(rand, false, luck);
            CompoundTag perkCompound = new CompoundTag();
            if (goodPerk == badPerk) {
                val = (val + badPerk.generateValue(rand, true, luck)) / 2.0;
            } else {
                perkCompound.putDouble(badPerk.getNBTKey(), badPerk.generateValue(rand, true, luck));
            }
            perkCompound.putDouble(goodPerk.getNBTKey(), val);
            return perkCompound;
        }
    }

    public record SpecialRevolver(String[] uuid, String tag, String flavour, HashMap<String, Object> baseUpgrades, String[] renderAdditions) {
    }
}

