/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.items.BuzzsawItem;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import com.google.common.collect.ImmutableSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.ToolAction;
import net.neoforged.neoforge.common.ToolActions;

public class SawbladeItem
extends IEBaseItem {
    private static final Set<ToolAction> TOOL_ACTIONS = ImmutableSet.of((Object)ToolActions.AXE_DIG, (Object)ToolActions.SWORD_DIG, (Object)ToolActions.SHEARS_CARVE);
    private final float sawbladeSpeed;
    private final float sawbladeDamage;
    private final ResourceLocation texture;

    public SawbladeItem(int maxDamage, float sawbladeSpeed, float sawbladeDamage, ResourceLocation texture) {
        super(new Item.Properties().defaultDurability(maxDamage).setNoRepair());
        this.sawbladeSpeed = sawbladeSpeed;
        this.sawbladeDamage = sawbladeDamage;
        this.texture = texture;
        BuzzsawItem.SAWBLADES.add(this);
    }

    public SawbladeItem(int maxDamage, float sawbladeSpeed, float sawbladeDamage) {
        this(maxDamage, sawbladeSpeed, sawbladeDamage, ImmersiveEngineering.rl("item/sawblade_blade"));
    }

    public boolean canBeDepleted() {
        return true;
    }

    public boolean isEnchantable(ItemStack stack) {
        return false;
    }

    @Override
    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public final ResourceLocation getSawbladeTexture() {
        return this.texture;
    }

    public float getSawbladeSpeed() {
        return this.sawbladeSpeed;
    }

    public float getSawbladeDamage() {
        return this.sawbladeDamage;
    }

    public int getSawbladeDamageFromBlock(boolean effective) {
        return effective ? 1 : 3;
    }

    public boolean canSawbladeFellTree() {
        return true;
    }

    public void modifyEnchants(Map<Enchantment, Integer> baseEnchants) {
    }

    public Predicate<BlockState> getSawbladeMaterials() {
        return s -> s.is(BlockTags.MINEABLE_WITH_AXE);
    }

    public Set<ToolAction> getToolActions() {
        return TOOL_ACTIONS;
    }
}

