/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Locale;
import javax.annotation.Nonnull;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;

public class ShaderBagItem
extends IEBaseItem
implements IEItemInterfaces.IColouredItem {
    @Nonnull
    private final Rarity rarity;

    public ShaderBagItem(Rarity rarity) {
        super(new Item.Properties());
        this.rarity = rarity;
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        return this.rarity.color.getColor();
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)("desc.immersiveengineering.info.shader.rarity." + this.rarity.name().toLowerCase(Locale.US))).append(" ").append(super.getName(stack));
    }

    public String getDescriptionId() {
        return "item.immersiveengineering.shader_bag";
    }

    public Rarity getRarity(ItemStack stack) {
        return this.rarity;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && ShaderRegistry.totalWeight.containsKey(this.rarity)) {
            ResourceLocation shader = ShaderRegistry.getRandomShader(player.getUUID(), player.getRandom(), this.rarity, true);
            if (shader == null) {
                return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
            }
            ItemStack shaderItem = new ItemStack(IEItems.Misc.SHADER);
            ItemNBTHelper.putString(shaderItem, "shader_name", shader.toString());
            Rarity shaderRarity = ShaderRegistry.shaderRegistry.get(shader).getRarity();
            if (ShaderRegistry.sortedRarityMap.indexOf(shaderRarity) <= ShaderRegistry.sortedRarityMap.indexOf(Rarity.EPIC) && ShaderRegistry.sortedRarityMap.indexOf(this.rarity) >= ShaderRegistry.sortedRarityMap.indexOf(Rarity.COMMON)) {
                Utils.unlockIEAdvancement(player, "main/secret_luckofthedraw");
            }
            stack.shrink(1);
            if (stack.getCount() <= 0) {
                return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)shaderItem);
            }
            if (!player.getInventory().add(shaderItem)) {
                player.drop(shaderItem, false, true);
            }
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }
}

