/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.client.TextUtils;
import blusunrize.immersiveengineering.api.shader.IShaderItem;
import blusunrize.immersiveengineering.api.shader.ShaderCase;
import blusunrize.immersiveengineering.api.shader.ShaderLayer;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.shader.impl.ShaderCaseItem;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerBlockEntity;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerStandingBlock;
import blusunrize.immersiveengineering.common.blocks.cloth.ShaderBannerWallBlock;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BannerBlock;
import net.minecraft.world.level.block.WallBannerBlock;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public class ShaderItem
extends IEBaseItem
implements IShaderItem,
IEItemInterfaces.IColouredItem {
    public static final String SHADER_NAME_KEY = "shader_name";

    public ShaderItem() {
        super(new Item.Properties().stacksTo(1));
    }

    @Override
    public ShaderCase getShaderCase(ItemStack shader, ResourceLocation shaderType) {
        return ShaderRegistry.getShader(this.getShaderName(shader), shaderType);
    }

    @Override
    public ResourceLocation getShaderName(ItemStack stack) {
        if (ItemNBTHelper.hasKey(stack, SHADER_NAME_KEY)) {
            return new ResourceLocation(ItemNBTHelper.getString(stack, SHADER_NAME_KEY));
        }
        return null;
    }

    @Nonnull
    public InteractionResult useOn(UseOnContext ctx) {
        Level world = ctx.getLevel();
        BlockPos pos = ctx.getClickedPos();
        ResourceLocation name = this.getShaderName(ctx.getItemInHand());
        if (ShaderRegistry.shaderRegistry.containsKey(name)) {
            BlockState blockState = world.getBlockState(pos);
            BlockEntity tile = world.getBlockEntity(pos);
            if (tile instanceof BannerBlockEntity) {
                ShaderCase sCase = ShaderRegistry.shaderRegistry.get(name).getCase(new ResourceLocation("immersiveengineering", "banner"));
                if (sCase != null) {
                    boolean wall = blockState.getBlock() instanceof WallBannerBlock;
                    if (wall) {
                        world.setBlockAndUpdate(pos, (BlockState)IEBlocks.Cloth.SHADER_BANNER_WALL.defaultBlockState().setValue(ShaderBannerWallBlock.FACING, (Comparable)((Direction)blockState.getValue((Property)WallBannerBlock.FACING))));
                    } else {
                        world.setBlockAndUpdate(pos, (BlockState)IEBlocks.Cloth.SHADER_BANNER.defaultBlockState().setValue((Property)ShaderBannerStandingBlock.ROTATION, (Comparable)((Integer)blockState.getValue((Property)BannerBlock.ROTATION))));
                    }
                    tile = world.getBlockEntity(pos);
                    if (tile instanceof ShaderBannerBlockEntity) {
                        ((ShaderBannerBlockEntity)tile).shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)ctx.getItemInHand(), (int)1));
                        tile.setChanged();
                        return InteractionResult.SUCCESS;
                    }
                }
            } else if (tile instanceof ShaderBannerBlockEntity) {
                ((ShaderBannerBlockEntity)tile).shader.setShaderItem(ItemHandlerHelper.copyStackWithSize((ItemStack)ctx.getItemInHand(), (int)1));
                tile.setChanged();
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.FAIL;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.level").append(this.getRarity((ItemStack)stack).color.toString()).append((Component)Component.translatable((String)("desc.immersiveengineering.info.shader.rarity." + this.getRarity(stack).name().toLowerCase(Locale.US)))).withStyle(ChatFormatting.GRAY));
        if (!Screen.hasShiftDown()) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.applyTo").append(" ").append((Component)Component.translatable((String)"desc.immersiveengineering.info.holdShift")).withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.shader.applyTo").withStyle(ChatFormatting.GRAY));
            ResourceLocation rl = this.getShaderName(stack);
            if (rl != null) {
                List<ShaderCase> array = ShaderRegistry.shaderRegistry.get(rl).getCases();
                for (ShaderCase sCase : array) {
                    if (sCase instanceof ShaderCaseItem) continue;
                    list.add((Component)TextUtils.applyFormat((Component)Component.translatable((String)("desc.immersiveengineering.info.shader." + sCase.getShaderType())), ChatFormatting.DARK_GRAY));
                }
            }
        }
    }

    @Nonnull
    public Component getName(@Nonnull ItemStack stack) {
        MutableComponent itc = super.getName(stack).copy();
        ResourceLocation rl = this.getShaderName(stack);
        if (rl != null) {
            itc.append(": ").append((Component)Component.translatable((String)("item." + rl.getNamespace() + ".shader.name." + rl.getPath())));
        }
        return itc;
    }

    @Nonnull
    public Rarity getRarity(ItemStack stack) {
        ResourceLocation rl = this.getShaderName(stack);
        return ShaderRegistry.shaderRegistry.containsKey(rl) ? ShaderRegistry.shaderRegistry.get(rl).getRarity() : Rarity.COMMON;
    }

    @Override
    public void fillCreativeTab(CreativeModeTab.Output out) {
        for (ResourceLocation key : ShaderRegistry.shaderRegistry.keySet()) {
            ItemStack s = new ItemStack((ItemLike)this);
            ItemNBTHelper.putString(s, SHADER_NAME_KEY, key.toString());
            out.accept(s);
        }
    }

    @Override
    public int getColourForIEItem(ItemStack stack, int pass) {
        ShaderCase sCase;
        ResourceLocation name = this.getShaderName(stack);
        if (ShaderRegistry.shaderRegistry.containsKey(name) && (sCase = ShaderRegistry.shaderRegistry.get(name).getCase(new ResourceLocation("immersiveengineering", "item"))) != null) {
            ShaderLayer[] layers = sCase.getLayers();
            if (pass < layers.length && layers[pass] != null) {
                return Utils.intFromRGBA(layers[pass].getColor());
            }
            return -1;
        }
        return -1;
    }
}

