/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.tool.IElectricEquipment;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.entities.SkyhookUserData;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.gui.IESlot;
import blusunrize.immersiveengineering.common.items.UpgradeableToolItem;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IEDamageSources;
import blusunrize.immersiveengineering.common.util.IELogger;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import blusunrize.immersiveengineering.common.util.SkylineHelper;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.player.CriticalHitEvent;
import net.neoforged.neoforge.items.IItemHandler;

@Mod.EventBusSubscriber(modid="immersiveengineering")
public class SkyhookItem
extends UpgradeableToolItem
implements IElectricEquipment {
    private static final String LIMIT_SPEED = "limitSpeed";

    public SkyhookItem() {
        super(new Item.Properties().stacksTo(1), "SKYHOOK");
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.skyhook").withStyle(ChatFormatting.GRAY));
        if (SkyhookItem.shouldLimitSpeed(stack)) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.skyhook.speedLimit").withStyle(ChatFormatting.GRAY));
        } else {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.skyhook.noLimit").withStyle(ChatFormatting.GRAY));
        }
    }

    public static boolean shouldLimitSpeed(ItemStack stack) {
        return ItemNBTHelper.getBoolean(stack, LIMIT_SPEED);
    }

    public static void setLimitSpeed(ItemStack stack, boolean doLimit) {
        ItemNBTHelper.putBoolean(stack, LIMIT_SPEED, doLimit);
    }

    public static boolean toggleSpeedLimit(ItemStack stack) {
        CompoundTag nbt;
        boolean wasActive = (nbt = stack.getOrCreateTag()).getBoolean(LIMIT_SPEED);
        nbt.putBoolean(LIMIT_SPEED, !wasActive);
        return !wasActive;
    }

    public void inventoryTick(ItemStack stack, Level world, Entity ent, int slot, boolean inHand) {
        super.inventoryTick(stack, world, ent, slot, inHand);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (slot == EquipmentSlot.MAINHAND) {
            builder.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(BASE_ATTACK_DAMAGE_UUID, "Weapon modifier", 5.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.ATTACK_SPEED, (Object)new AttributeModifier(BASE_ATTACK_SPEED_UUID, "Weapon modifier", -2.4, AttributeModifier.Operation.ADDITION));
        }
        return builder.build();
    }

    @SubscribeEvent
    public static void criticalHit(CriticalHitEvent ev) {
        ItemStack heldItem = ev.getEntity().getMainHandItem();
        if (heldItem.is(IEItems.Misc.SKYHOOK.asItem()) && SkyhookItem.getUpgradesStatic(heldItem).getBoolean("maceAttack") && ev.isVanillaCritical()) {
            float fallDistance = ev.getEntity().fallDistance;
            if ((double)fallDistance < 1.5) {
                return;
            }
            float damageBonus = fallDistance <= 3.0f ? 0.66f * fallDistance : (fallDistance <= 8.0f ? 2.0f + 0.33f * (fallDistance - 3.0f) : 3.65f + 0.165f * (fallDistance - 8.0f));
            ev.setDamageModifier(ev.getDamageModifier() + damageBonus);
            ev.getEntity().fallDistance = 0.0f;
        }
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getCooldowns().isOnCooldown((Item)this)) {
            return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
        }
        if (player.isShiftKeyDown()) {
            boolean limitSpeed = SkyhookItem.toggleSpeedLimit(stack);
            if (limitSpeed) {
                player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.skyhookLimited"), true);
            } else {
                player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.skyhookUnlimited"), true);
            }
        } else {
            SkyhookUserData data = (SkyhookUserData)player.getData(IEDataAttachments.SKYHOOK_USER.get());
            if (data.hook != null && !world.isClientSide) {
                data.dismount();
                IELogger.logger.info("Player left voluntarily");
            } else {
                data.startHolding();
                player.startUsingItem(hand);
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    public void onUseTick(Level level, LivingEntity player, ItemStack stack, int count) {
        super.onUseTick(level, player, stack, count);
        SkyhookUserData data = (SkyhookUserData)player.getData(IEDataAttachments.SKYHOOK_USER.get());
        if (data.getStatus() != SkyhookUserData.SkyhookStatus.HOLDING_CONNECTING) {
            return;
        }
        Connection con = WireUtils.getConnectionMovedThrough(level, player);
        if (con != null) {
            SkylineHelper.spawnHook(player, con, player.getUsedItemHand(), SkyhookItem.shouldLimitSpeed(stack), this.getSlopeModifier(stack));
        }
    }

    public void releaseUsing(ItemStack stack, Level worldIn, LivingEntity player, int timeLeft) {
        super.releaseUsing(stack, worldIn, player, timeLeft);
        if (!worldIn.isClientSide) {
            ((SkyhookUserData)player.getData(IEDataAttachments.SKYHOOK_USER.get())).release();
        }
    }

    public float getSlopeModifier(ItemStack stack) {
        CompoundTag upgrades = this.getUpgrades(stack);
        if (upgrades.contains("slopeModifier")) {
            return Math.max(upgrades.getFloat("slopeModifier"), 0.5f);
        }
        return 1.0f;
    }

    @Override
    public void onStrike(ItemStack equipped, EquipmentSlot eqSlot, LivingEntity owner, Map<String, Object> cache, @Nullable DamageSource dmg, IElectricEquipment.ElectricSource desc) {
        if (dmg instanceof IEDamageSources.ElectricDamageSource) {
            IEDamageSources.ElectricDamageSource eds = (IEDamageSources.ElectricDamageSource)dmg;
            if (dmg.is(Lib.DamageTypes.WIRE_SHOCK) && this.getUpgrades(equipped).getBoolean("insulated") && (owner.getVehicle() instanceof SkylineHookEntity || owner.isUsingItem())) {
                eds.dmg = 0.0f;
            }
        }
    }

    public int getUseDuration(ItemStack stack) {
        return 72000;
    }

    @Override
    public boolean canModify(ItemStack stack) {
        return true;
    }

    @Override
    public Slot[] getWorkbenchSlots(AbstractContainerMenu container, ItemStack stack, Level level, Supplier<Player> getPlayer, IItemHandler toolInventory) {
        return new Slot[]{new IESlot.Upgrades(container, toolInventory, 0, 102, 42, "SKYHOOK", stack, true, level, getPlayer), new IESlot.Upgrades(container, toolInventory, 1, 102, 22, "SKYHOOK", stack, true, level, getPlayer)};
    }

    @Override
    public int getSlotCount() {
        return 2;
    }
}

