/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.EnumMetals;
import blusunrize.immersiveengineering.api.IETags;
import javax.annotation.Nonnull;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;

public class SteelArmorItem
extends ArmorItem {
    public static ArmorMaterial mat = new SteelArmorMaterial();

    public SteelArmorItem(ArmorItem.Type type) {
        super(mat, type, new Item.Properties().stacksTo(1));
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return "immersiveengineering:textures/models/armor_steel" + (slot == EquipmentSlot.LEGS ? "_legs" : "") + ".png";
    }

    private static class SteelArmorMaterial
    implements ArmorMaterial {
        private SteelArmorMaterial() {
        }

        public int getDurabilityForType(@Nonnull ArmorItem.Type slotIn) {
            return switch (slotIn) {
                case ArmorItem.Type.BOOTS -> 273;
                case ArmorItem.Type.LEGGINGS -> 315;
                case ArmorItem.Type.CHESTPLATE -> 336;
                case ArmorItem.Type.HELMET -> 231;
                default -> 0;
            };
        }

        public int getDefenseForType(ArmorItem.Type slotIn) {
            return switch (slotIn) {
                case ArmorItem.Type.BOOTS, ArmorItem.Type.HELMET -> 2;
                case ArmorItem.Type.LEGGINGS -> 6;
                case ArmorItem.Type.CHESTPLATE -> 7;
                default -> 0;
            };
        }

        public int getEnchantmentValue() {
            return 10;
        }

        @Nonnull
        public SoundEvent getEquipSound() {
            return SoundEvents.ARMOR_EQUIP_IRON;
        }

        @Nonnull
        public Ingredient getRepairIngredient() {
            return Ingredient.of(IETags.getTagsFor((EnumMetals)EnumMetals.STEEL).ingot);
        }

        @Nonnull
        public String getName() {
            return "immersiveengineering:steel";
        }

        public float getToughness() {
            return 1.0f;
        }

        public float getKnockbackResistance() {
            return 0.0f;
        }
    }
}

