/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.excavator.ExcavatorHandler;
import blusunrize.immersiveengineering.api.excavator.MineralMix;
import blusunrize.immersiveengineering.api.excavator.MineralVein;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec2;

public class SurveyToolsItem
extends IEBaseItem {
    private static final List<BiPredicate<Level, BlockPos>> CAN_USE_ON = new ArrayList<BiPredicate<Level, BlockPos>>();
    private static final String DATA_KEY = "veinData";

    public SurveyToolsItem() {
        super(new Item.Properties().stacksTo(1).defaultDurability(300));
        CAN_USE_ON.add((world, pos) -> world.getBlockState(pos).is(IETags.surveyToolTargets));
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack stack) {
        return 50;
    }

    public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.PASS;
        }
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        if (!CAN_USE_ON.stream().anyMatch(predicate -> predicate.test(world, pos))) {
            player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.survey.wrong_block"), true);
            return InteractionResult.FAIL;
        }
        player.startUsingItem(context.getHand());
        return InteractionResult.SUCCESS;
    }

    public ItemStack finishUsingItem(ItemStack stack, Level world, LivingEntity entityLiving) {
        MutableComponent response;
        if (!(entityLiving instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)entityLiving;
        BlockHitResult rtr = SurveyToolsItem.getPlayerPOVHitResult((Level)world, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
        BlockPos pos = rtr.getBlockPos();
        MineralVein vein = ExcavatorHandler.getRandomMineral(world, pos);
        if (vein == null || vein.getMineral(world) == null) {
            player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.survey.no_vein"), true);
            return stack;
        }
        ListTag data = SurveyToolsItem.getVeinData(stack, (ResourceKey<Level>)world.dimension(), vein.getPos());
        int dataCount = data.size();
        boolean tooClose = data.stream().anyMatch(inbt -> {
            int dZ;
            int dX = ((CompoundTag)inbt).getInt("x") - pos.getX();
            return dX * dX + (dZ = ((CompoundTag)inbt).getInt("z") - pos.getZ()) * dZ < 16;
        });
        if (tooClose) {
            player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.survey.too_close"), true);
            return stack;
        }
        Vec2 vecToCenter = new Vec2((float)(vein.getPos().x() - pos.getX()), (float)(vein.getPos().z() - pos.getZ()));
        if (vecToCenter.x == 0.0f && vecToCenter.y == 0.0f) {
            response = Component.translatable((String)"chat.immersiveengineering.info.survey.hint.center", (Object[])new Object[]{Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName()))});
        } else {
            double angle = Math.toDegrees(Math.atan2(vecToCenter.y, vecToCenter.x));
            int segment = (int)((angle + 270.0) % 360.0 / 45.0);
            switch (dataCount) {
                case 0: {
                    response = Component.translatable((String)"chat.immersiveengineering.info.survey.hint.1", (Object[])new Object[]{Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName()))});
                    break;
                }
                case 1: {
                    response = Component.translatable((String)"chat.immersiveengineering.info.survey.hint.2", (Object[])new Object[]{Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName())), Component.translatable((String)("chat.immersiveengineering.info.survey.direction." + segment))});
                    break;
                }
                default: {
                    response = Component.translatable((String)"chat.immersiveengineering.info.survey.hint.3", (Object[])new Object[]{Component.translatable((String)MineralMix.getTranslationKey(vein.getMineralName())), Math.round(Math.sqrt(vecToCenter.x * vecToCenter.x + vecToCenter.y * vecToCenter.y)), Component.translatable((String)("chat.immersiveengineering.info.survey.direction." + segment))});
                }
            }
        }
        player.displayClientMessage((Component)response, false);
        CompoundTag tag = new CompoundTag();
        tag.putInt("x", pos.getX());
        tag.putInt("z", pos.getZ());
        tag.putString("hint", Component.Serializer.toJson((Component)response));
        data.add((Object)tag);
        world.playSound(null, player.getX(), player.getY(), player.getZ(), SoundEvents.BOOK_PAGE_TURN, SoundSource.NEUTRAL, 1.0f, 1.0f + (world.random.nextFloat() - world.random.nextFloat()) * 0.4f);
        stack.hurtAndBreak(1, (LivingEntity)player, user -> user.broadcastBreakEvent(user.getUsedItemHand()));
        return stack;
    }

    public static ListTag getVeinData(ItemStack surveyTools, ResourceKey<Level> dimension, ColumnPos veinPos) {
        ListTag list = surveyTools.getOrCreateTag().getList(DATA_KEY, 10);
        CompoundTag tag = null;
        String dimString = dimension.location().toString();
        for (Tag nbt : list) {
            CompoundTag tmp = (CompoundTag)nbt;
            if (!dimString.equals(tmp.getString("dimension")) || tmp.getInt("x") != veinPos.x() || tmp.getInt("z") != veinPos.z()) continue;
            tag = tmp;
            break;
        }
        if (tag == null) {
            tag = new CompoundTag();
            tag.putString("dimension", dimString);
            tag.putInt("x", veinPos.x());
            tag.putInt("z", veinPos.z());
            list.add((Object)tag);
            surveyTools.getOrCreateTag().put(DATA_KEY, (Tag)list);
        }
        if (tag.contains("data", 9)) {
            return tag.getList("data", 10);
        }
        ListTag data = new ListTag();
        tag.put("data", (Tag)data);
        return data;
    }

    public boolean doesSneakBypassUse(ItemStack stack, LevelReader world, BlockPos pos, Player player) {
        return true;
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return false;
    }
}

