/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.tool.IUpgrade;
import blusunrize.immersiveengineering.api.tool.IUpgradeableTool;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.items.PowerpackItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ToolUpgradeItem
extends IEBaseItem
implements IUpgrade {
    private final ToolUpgrade type;

    public ToolUpgradeItem(ToolUpgrade type) {
        super(new Item.Properties().stacksTo(1));
        this.type = type;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        list.add((Component)Component.translatable((String)("desc.immersiveengineering.flavour." + BuiltInRegistries.ITEM.getKey((Object)this).getPath())).withStyle(ChatFormatting.GRAY));
    }

    public int getMaxStackSize(ItemStack stack) {
        return this.type.stackSize;
    }

    @Override
    public Set<String> getUpgradeTypes(ItemStack upgrade) {
        return this.type.toolset;
    }

    @Override
    public boolean canApplyUpgrades(ItemStack target, ItemStack upgrade) {
        BiPredicate<ItemStack, ItemStack> check = this.type.applyCheck;
        if (check != null && target.getItem() instanceof IUpgradeableTool) {
            return check.test(target, upgrade);
        }
        return true;
    }

    @Override
    public void applyUpgrades(ItemStack target, ItemStack upgrade, CompoundTag modifications) {
        this.type.function.accept(upgrade, modifications);
    }

    public static enum ToolUpgrade {
        DRILL_WATERPROOF((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), (upgrade, modifications) -> modifications.putBoolean("waterproof", true)),
        DRILL_LUBE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL", (Object)"BUZZSAW"), (upgrade, modifications) -> modifications.putBoolean("oiled", true)),
        DRILL_DAMAGE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), 3, (upgrade, modifications) -> {
            ItemNBTHelper.modifyFloat(modifications, "speed", (float)upgrade.getCount() * 2.0f);
            ItemNBTHelper.modifyInt(modifications, "damage", upgrade.getCount());
        }),
        DRILL_FORTUNE((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL"), (upgrade, modifications) -> modifications.putBoolean("fortune", true)),
        DRILL_CAPACITY((ImmutableSet<String>)ImmutableSet.of((Object)"DRILL", (Object)"CHEMTHROWER", (Object)"BUZZSAW"), 1, (target, upgrade) -> !((IUpgradeableTool)target.getItem()).getUpgrades((ItemStack)target).contains("multitank"), (upgrade, modifications) -> ItemNBTHelper.modifyInt(modifications, "capacity", 2000)),
        REVOLVER_BAYONET((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), (upgrade, modifications) -> ItemNBTHelper.modifyFloat(modifications, "melee", 6.0f)),
        REVOLVER_MAGAZINE((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), 1, (target, upgrade) -> !((IUpgradeableTool)target.getItem()).getUpgrades((ItemStack)target).contains("bullets"), (upgrade, modifications) -> ItemNBTHelper.modifyInt(modifications, "bullets", 6)),
        REVOLVER_ELECTRO((ImmutableSet<String>)ImmutableSet.of((Object)"REVOLVER"), (upgrade, modifications) -> modifications.putBoolean("electro", true)),
        CHEMTHROWER_FOCUS((ImmutableSet<String>)ImmutableSet.of((Object)"CHEMTHROWER"), (upgrade, modifications) -> modifications.putBoolean("focus", true)),
        RAILGUN_SCOPE((ImmutableSet<String>)ImmutableSet.of((Object)"RAILGUN", (Object)"REVOLVER"), (upgrade, modifications) -> modifications.putBoolean("scope", true)),
        RAILGUN_CAPACITORS((ImmutableSet<String>)ImmutableSet.of((Object)"RAILGUN"), (upgrade, modifications) -> modifications.putFloat("speed", 1.0f)),
        SHIELD_FLASH((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.putBoolean("flash", true)),
        SHIELD_SHOCK((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.putBoolean("shock", true)),
        SHIELD_MAGNET((ImmutableSet<String>)ImmutableSet.of((Object)"SHIELD"), (upgrade, modifications) -> modifications.putBoolean("magnet", true)),
        CHEMTHROWER_MULTITANK((ImmutableSet<String>)ImmutableSet.of((Object)"CHEMTHROWER"), 1, (target, upgrade) -> !((IUpgradeableTool)target.getItem()).getUpgrades((ItemStack)target).contains("capacity"), (upgrade, modifications) -> modifications.putBoolean("multitank", true)),
        BUZZSAW_SPAREBLADES((ImmutableSet<String>)ImmutableSet.of((Object)"BUZZSAW"), 1, (upgrade, modifications) -> modifications.putBoolean("spareblades", true)),
        POWERPACK_ANTENNA((ImmutableSet<String>)ImmutableSet.of((Object)"POWERPACK"), 1, (target, upgrade) -> !PowerpackItem.getUpgradesStatic(target).contains("tesla"), (upgrade, modifications) -> modifications.putBoolean("antenna", true)),
        POWERPACK_INDUCTION((ImmutableSet<String>)ImmutableSet.of((Object)"POWERPACK"), 1, (upgrade, modifications) -> modifications.putBoolean("induction", true)),
        POWERPACK_TESLA((ImmutableSet<String>)ImmutableSet.of((Object)"POWERPACK"), 1, (target, upgrade) -> !PowerpackItem.getUpgradesStatic(target).contains("antenna"), (upgrade, modifications) -> modifications.putBoolean("tesla", true)),
        POWERPACK_MAGNET((ImmutableSet<String>)ImmutableSet.of((Object)"POWERPACK"), 1, (upgrade, modifications) -> modifications.putBoolean("magnet", true)),
        SKYHOOK_SLOPE((ImmutableSet<String>)ImmutableSet.of((Object)"SKYHOOK"), 1, (upgrade, modifications) -> modifications.putFloat("slopeModifier", 0.5f)),
        SKYHOOK_INSULATION((ImmutableSet<String>)ImmutableSet.of((Object)"SKYHOOK"), 1, (upgrade, modifications) -> modifications.putBoolean("insulated", true)),
        SKYHOOK_MACE((ImmutableSet<String>)ImmutableSet.of((Object)"SKYHOOK"), 1, (upgrade, modifications) -> modifications.putBoolean("maceAttack", true));

        private ImmutableSet<String> toolset;
        private int stackSize = 1;
        private BiPredicate<ItemStack, ItemStack> applyCheck;
        private BiConsumer<ItemStack, CompoundTag> function;

        private ToolUpgrade(ImmutableSet<String> toolset, BiConsumer<ItemStack, CompoundTag> function) {
            this(toolset, 1, function);
        }

        private ToolUpgrade(ImmutableSet<String> toolset, int stackSize, BiConsumer<ItemStack, CompoundTag> function) {
            this(toolset, stackSize, null, function);
        }

        private ToolUpgrade(ImmutableSet<String> toolset, int stackSize, BiPredicate<ItemStack, ItemStack> applyCheck, BiConsumer<ItemStack, CompoundTag> function) {
            this.toolset = toolset;
            this.stackSize = stackSize;
            this.applyCheck = applyCheck;
            this.function = function;
        }
    }
}

