/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.localhandlers.EnergyTransferHandler;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.network.MessageRequestEnergyUpdate;
import blusunrize.immersiveengineering.common.network.MessageRequestRedstoneUpdate;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;

public class VoltmeterItem
extends IEBaseItem {
    public static RemoteEnergyData lastEnergyUpdate = new RemoteEnergyData(FastEither.left(BlockPos.ZERO), 0L, false, 0, 0);
    public static RemoteRedstoneData lastRedstoneUpdate = new RemoteRedstoneData(BlockPos.ZERO, 0L, false, 0);

    public VoltmeterItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.appendHoverText(stack, worldIn, tooltip, flagIn);
        if (WirecoilUtils.hasWireLink(stack)) {
            WireLink link = WireLink.readFromItem(stack);
            tooltip.add((Component)Component.translatable((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link.cp.getX(), link.cp.getY(), link.cp.getZ(), link.dimension.toString()}));
        }
    }

    public InteractionResult useOn(UseOnContext context) {
        IEnergyStorage energyCap;
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Player player = context.getPlayer();
        ItemStack stack = context.getItemInHand();
        BlockEntity bEntity = world.getBlockEntity(pos);
        if (!(player != null && player.isShiftKeyDown() || (energyCap = (IEnergyStorage)world.getCapability(Capabilities.EnergyStorage.BLOCK, pos, null)) == null)) {
            int max = energyCap.getMaxEnergyStored();
            int stored = energyCap.getEnergyStored();
            if (max > 0) {
                ChatUtils.sendServerNoSpamMessages(player, (Component)Component.translatable((String)"chat.immersiveengineering.info.energyStorage", (Object[])new Object[]{stored, max}));
            }
            return InteractionResult.SUCCESS;
        }
        if (player != null && player.isShiftKeyDown()) {
            if (bEntity instanceof IImmersiveConnectable) {
                if (world.isClientSide) {
                    return InteractionResult.SUCCESS;
                }
                TargetingInfo targetingInfo = new TargetingInfo(context);
                BlockPos masterPos = ((IImmersiveConnectable)bEntity).getConnectionMaster(null, targetingInfo);
                BlockPos delta = pos.subtract((Vec3i)masterPos);
                ConnectionPoint cp = ((IImmersiveConnectable)bEntity).getTargetedPoint(targetingInfo, (Vec3i)delta);
                if (cp == null) {
                    return InteractionResult.FAIL;
                }
                if (!WirecoilUtils.hasWireLink(stack)) {
                    WireLink link = WireLink.create(cp, world, delta, targetingInfo);
                    link.writeToItem(stack);
                } else {
                    EnergyTransferHandler energyHandler;
                    LocalWireNetwork netLink;
                    GlobalWireNetwork global;
                    LocalWireNetwork netHere;
                    WireLink link = WireLink.readFromItem(stack);
                    if (link.dimension.equals((Object)world.dimension()) && (netHere = (global = GlobalWireNetwork.getNetwork(world)).getNullableLocalNet(cp)) == (netLink = global.getNullableLocalNet(link.cp)) && netHere != null && (energyHandler = netHere.getHandler(EnergyTransferHandler.ID, EnergyTransferHandler.class)) != null) {
                        EnergyTransferHandler.Path energyPath = energyHandler.getPath(link.cp, cp);
                        double loss = energyPath != null ? energyPath.loss : 1.0;
                        player.sendSystemMessage((Component)Component.translatable((String)"chat.immersiveengineering.info.averageLoss", (Object[])new Object[]{Utils.formatDouble(loss * 100.0, "###.000")}));
                    }
                    WirecoilUtils.clearWireLink(stack);
                }
                return InteractionResult.SUCCESS;
            }
            if (!world.isClientSide) {
                ChatUtils.sendServerNoSpamMessages(player, (Component)Component.translatable((String)"chat.immersiveengineering.info.redstoneLevel", (Object[])new Object[]{MessageRequestRedstoneUpdate.redstoneLevel(world, pos)}));
            }
        }
        return InteractionResult.PASS;
    }

    public record RemoteEnergyData(FastEither<BlockPos, Integer> pos, long measuredInTick, boolean isValid, int stored, int capacity) {
        public static RemoteEnergyData read(FriendlyByteBuf in) {
            int capacity;
            int stored;
            FastEither<BlockPos, Integer> pos = MessageRequestEnergyUpdate.readPos(in);
            long measuredInTick = in.readVarLong();
            boolean isValid = in.readBoolean();
            if (isValid) {
                stored = in.readVarInt();
                capacity = in.readVarInt();
            } else {
                capacity = 0;
                stored = 0;
            }
            return new RemoteEnergyData(pos, measuredInTick, isValid, stored, capacity);
        }

        public void write(FriendlyByteBuf out) {
            MessageRequestEnergyUpdate.writePos(out, this.pos);
            out.writeVarLong(this.measuredInTick).writeBoolean(this.isValid);
            if (this.isValid) {
                out.writeVarInt(this.stored).writeVarInt(this.capacity);
            }
        }
    }

    public record RemoteRedstoneData(BlockPos pos, long measuredInTick, boolean isSignalSource, byte rsLevel) {
        public static RemoteRedstoneData read(FriendlyByteBuf in) {
            BlockPos pos = in.readBlockPos();
            long measuredInTick = in.readVarLong();
            boolean isSignalSource = in.readBoolean();
            byte rsLevel = in.readByte();
            return new RemoteRedstoneData(pos, measuredInTick, isSignalSource, rsLevel);
        }

        public void write(FriendlyByteBuf out) {
            out.writeBlockPos(this.pos);
            out.writeVarLong(this.measuredInTick).writeBoolean(this.isSignalSource);
            out.writeByte(this.rsLevel);
        }
    }
}

