/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.IWireCoil;
import blusunrize.immersiveengineering.api.wires.LocalWireNetwork;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.api.wires.utils.WireLink;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.api.wires.utils.WirecoilUtils;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.network.MessageObstructedConnection;
import blusunrize.immersiveengineering.common.util.Utils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.PacketDistributor;

public class WireCoilItem
extends IEBaseItem
implements IWireCoil {
    @Nonnull
    private final WireType type;

    public WireCoilItem(@Nonnull WireType type) {
        super(new Item.Properties());
        this.type = type;
    }

    @Override
    public WireType getWireType(ItemStack stack) {
        return this.type;
    }

    public void appendHoverText(ItemStack stack, @Nullable Level world, List<Component> list, TooltipFlag flag) {
        if ("REDSTONE".equals(this.type.getCategory())) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.coil.redstone").withStyle(ChatFormatting.GRAY));
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.coil.construction1").withStyle(ChatFormatting.GRAY));
        } else if ("STRUCTURE".equals(this.type.getCategory())) {
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.coil.construction0").withStyle(ChatFormatting.GRAY));
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.flavour.coil.construction1").withStyle(ChatFormatting.GRAY));
        }
        if (WirecoilUtils.hasWireLink(stack)) {
            WireLink link = WireLink.readFromItem(stack);
            String dimensionName = "";
            if (link.dimension != null) {
                String s2 = link.dimension.location().getPath();
                if (s2.toLowerCase(Locale.ENGLISH).startsWith("the_")) {
                    s2 = s2.substring(4);
                }
                dimensionName = Utils.toCamelCase(s2);
            }
            list.add((Component)Component.translatable((String)"desc.immersiveengineering.info.attachedToDim", (Object[])new Object[]{link.cp.getX(), link.cp.getY(), link.cp.getZ(), dimensionName}));
        }
    }

    public InteractionResult useOn(UseOnContext ctx) {
        return WirecoilUtils.doCoilUse(this, ctx.getPlayer(), ctx.getLevel(), ctx.getClickedPos(), ctx.getHand(), ctx.getClickedFace(), (float)ctx.getClickLocation().x, (float)ctx.getClickLocation().y, (float)ctx.getClickLocation().z);
    }

    public static InteractionResult doCoilUse(IWireCoil coil, Player player, Level world, BlockPos pos, InteractionHand hand, Direction side, float hitX, float hitY, float hitZ) {
        BlockEntity tileEntity = world.getBlockEntity(pos);
        if (tileEntity instanceof IImmersiveConnectable && ((IImmersiveConnectable)tileEntity).canConnect()) {
            IImmersiveConnectable iicHere;
            ItemStack stack = player.getItemInHand(hand);
            TargetingInfo targetHere = new TargetingInfo(side, hitX - (float)pos.getX(), hitY - (float)pos.getY(), hitZ - (float)pos.getZ());
            WireType wire = coil.getWireType(stack);
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(wire, targetHere);
            BlockPos masterOffsetHere = pos.subtract((Vec3i)masterPos);
            tileEntity = world.getBlockEntity(masterPos);
            if (!(tileEntity instanceof IImmersiveConnectable) || !(iicHere = (IImmersiveConnectable)tileEntity).canConnect()) {
                return InteractionResult.PASS;
            }
            ConnectionPoint cpHere = iicHere.getTargetedPoint(targetHere, (Vec3i)masterOffsetHere);
            if (cpHere == null || !iicHere.canConnectCable(wire, cpHere, (Vec3i)masterOffsetHere) || !coil.canConnectCable(stack, tileEntity)) {
                if (!world.isClientSide) {
                    player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.warning.wrongCable"), true);
                }
                return InteractionResult.FAIL;
            }
            if (!world.isClientSide) {
                if (!WirecoilUtils.hasWireLink(stack)) {
                    WireLink link = WireLink.create(cpHere, world, masterOffsetHere, targetHere);
                    link.writeToItem(stack);
                } else {
                    WireLink otherLink = WireLink.readFromItem(stack);
                    BlockEntity tileEntityLinkingPos = world.getBlockEntity(otherLink.cp.position());
                    int distanceSq = (int)Math.ceil(otherLink.cp.position().distSqr((Vec3i)masterPos));
                    int maxLengthSq = coil.getMaxLength(stack);
                    maxLengthSq *= maxLengthSq;
                    if (!otherLink.dimension.equals((Object)world.dimension())) {
                        player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.warning.wrongDimension"), true);
                    } else if (otherLink.cp.position().equals((Object)masterPos)) {
                        player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.warning.sameConnection"), true);
                    } else if (distanceSq > maxLengthSq) {
                        player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.warning.tooFar"), true);
                    } else if (!(tileEntityLinkingPos instanceof IImmersiveConnectable)) {
                        player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.warning.invalidPoint"), true);
                    } else {
                        IImmersiveConnectable iicLink = (IImmersiveConnectable)tileEntityLinkingPos;
                        if (!(iicLink.canConnectCable(wire, otherLink.cp, (Vec3i)otherLink.offset) && iicLink.getConnectionMaster(wire, otherLink.target).equals((Object)otherLink.cp.position()) && coil.canConnectCable(stack, tileEntityLinkingPos))) {
                            player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.warning.invalidPoint"), true);
                        } else {
                            Collection<Connection> outputs;
                            LocalWireNetwork localB;
                            GlobalWireNetwork net = GlobalWireNetwork.getNetwork(world);
                            boolean connectionExists = false;
                            LocalWireNetwork localA = net.getLocalNet(cpHere);
                            if (localA == (localB = net.getLocalNet(otherLink.cp)) && (outputs = localA.getConnections(cpHere)) != null) {
                                for (Connection con : outputs) {
                                    if (con.isInternal() || !con.getOtherEnd(cpHere).equals(otherLink.cp)) continue;
                                    connectionExists = true;
                                }
                            }
                            if (connectionExists) {
                                player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.warning.connectionExists"), true);
                            } else {
                                HashSet<BlockPos> ignore = new HashSet<BlockPos>();
                                ignore.addAll(iicHere.getIgnored(iicLink));
                                ignore.addAll(iicLink.getIgnored(iicHere));
                                Connection conn = new Connection(wire, cpHere, otherLink.cp, net);
                                Set<BlockPos> failedReasons = WireUtils.findObstructingBlocks(world, conn, ignore);
                                if (failedReasons.isEmpty()) {
                                    net.addConnection(conn);
                                    iicHere.connectCable(wire, cpHere, iicLink, otherLink.cp);
                                    iicLink.connectCable(wire, otherLink.cp, iicHere, cpHere);
                                    Utils.unlockIEAdvancement(player, "main/connect_wire");
                                    if (!player.getAbilities().instabuild) {
                                        coil.consumeWire(stack, (int)Math.sqrt(distanceSq));
                                    }
                                    ((BlockEntity)iicHere).setChanged();
                                    world.blockEvent(masterPos, ((BlockEntity)iicHere).getBlockState().getBlock(), -1, 0);
                                    BlockState state = world.getBlockState(masterPos);
                                    world.sendBlockUpdated(masterPos, state, state, 3);
                                    ((BlockEntity)iicLink).setChanged();
                                    world.blockEvent(otherLink.cp.position(), tileEntityLinkingPos.getBlockState().getBlock(), -1, 0);
                                    state = world.getBlockState(otherLink.cp.position());
                                    world.sendBlockUpdated(otherLink.cp.position(), state, state, 3);
                                } else {
                                    player.displayClientMessage((Component)Component.translatable((String)"chat.immersiveengineering.warning.cantSee"), true);
                                    PacketDistributor.PLAYER.with((Object)((ServerPlayer)player)).send(new CustomPacketPayload[]{new MessageObstructedConnection(conn, failedReasons)});
                                }
                            }
                        }
                    }
                    WirecoilUtils.clearWireLink(stack);
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

