/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.items;

import blusunrize.immersiveengineering.api.ApiUtils;
import blusunrize.immersiveengineering.api.IETags;
import blusunrize.immersiveengineering.api.Lib;
import blusunrize.immersiveengineering.api.TargetingInfo;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.api.wires.IImmersiveConnectable;
import blusunrize.immersiveengineering.api.wires.utils.WireUtils;
import blusunrize.immersiveengineering.common.config.IEServerConfig;
import blusunrize.immersiveengineering.common.items.IEBaseItem;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.common.Tags;
import net.neoforged.neoforge.common.ToolAction;

public class WirecutterItem
extends IEBaseItem {
    public WirecutterItem() {
        super(new Item.Properties().defaultDurability(100));
    }

    public int getMaxDamage(ItemStack stack) {
        return IEServerConfig.getOrDefault(IEServerConfig.TOOLS.cutterDurabiliy);
    }

    @Nonnull
    public ItemStack getCraftingRemainingItem(@Nonnull ItemStack stack) {
        ItemStack container = stack.copy();
        if (container.hurt(1, ApiUtils.RANDOM_SOURCE, null)) {
            return ItemStack.EMPTY;
        }
        return container;
    }

    public boolean hasCraftingRemainingItem(@Nonnull ItemStack stack) {
        return true;
    }

    public boolean canBeDepleted() {
        return true;
    }

    public boolean isEnchantable(@Nonnull ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 14;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment == Enchantments.BLOCK_EFFICIENCY || enchantment == Enchantments.UNBREAKING || enchantment == Enchantments.MENDING;
    }

    public boolean isValidRepairItem(ItemStack stack, ItemStack repairCandidate) {
        return repairCandidate.is(Tags.Items.INGOTS_IRON);
    }

    public boolean mineBlock(ItemStack itemstack, Level pLevel, BlockState state, BlockPos pPos, LivingEntity pEntityLiving) {
        boolean effective = state.is(IETags.wirecutterHarvestable);
        itemstack.hurt(1, ApiUtils.RANDOM_SOURCE, null);
        return effective;
    }

    public float getDestroySpeed(ItemStack stack, BlockState state) {
        if (this.isCorrectToolForDrops(stack, state)) {
            return 6.0f;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.is(IETags.wirecutterHarvestable);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == Lib.WIRECUTTER_DIG;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        BlockPos pos = context.getClickedPos();
        BlockEntity tileEntity = world.getBlockEntity(pos);
        TargetingInfo target = new TargetingInfo(context.getClickedFace(), (float)context.getClickLocation().x, (float)context.getClickLocation().y, (float)context.getClickLocation().z);
        ItemStack stack = context.getItemInHand();
        Player player = context.getPlayer();
        if (player != null && tileEntity instanceof IImmersiveConnectable) {
            BlockPos masterPos = ((IImmersiveConnectable)tileEntity).getConnectionMaster(null, target);
            if (!((tileEntity = world.getBlockEntity(masterPos)) instanceof IImmersiveConnectable)) {
                return InteractionResult.PASS;
            }
            if (!world.isClientSide) {
                IImmersiveConnectable nodeHere = (IImmersiveConnectable)tileEntity;
                GlobalWireNetwork net = GlobalWireNetwork.getNetwork(world);
                AtomicBoolean cut = new AtomicBoolean(false);
                net.removeAllConnectionsAt(nodeHere, conn -> {
                    ItemStack coil = conn.type.getWireCoil((Connection)conn);
                    if (world.getGameRules().getBoolean(GameRules.RULE_DOBLOCKDROPS)) {
                        world.addFreshEntity((Entity)new ItemEntity(world, player.getX(), player.getY(), player.getZ(), coil, 0.0, 0.0, 0.0));
                    }
                    cut.set(true);
                });
                if (cut.get()) {
                    this.damageStack(stack, player, context.getHand());
                }
            }
        } else if (player != null) {
            return this.use(world, player, context.getHand()).getResult();
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> use(Level world, Player player, @Nonnull InteractionHand hand) {
        double reachDistance;
        Connection target;
        ItemStack stack = player.getItemInHand(hand);
        if (!world.isClientSide && (target = WireUtils.getTargetConnection(world, player, null, reachDistance = player.getAttribute((Attribute)NeoForgeMod.BLOCK_REACH.value()).getValue())) != null) {
            GlobalWireNetwork.getNetwork(world).removeInsertAndDropConnection(target, player, world);
            this.damageStack(stack, player, hand);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    private void damageStack(ItemStack stack, Player player, InteractionHand hand) {
        int nbtDamage = ItemNBTHelper.getInt(stack, "Damage") + 1;
        if (nbtDamage < (Integer)IEServerConfig.TOOLS.cutterDurabiliy.get()) {
            ItemNBTHelper.putInt(stack, "Damage", nbtDamage);
        } else {
            player.broadcastBreakEvent(hand);
            player.setItemInHand(hand, ItemStack.EMPTY);
        }
    }
}

