/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class MessageBlockEntitySync
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("be_sync");
    private final BlockPos pos;
    private final CompoundTag nbt;

    public MessageBlockEntitySync(IEBaseBlockEntity tile, CompoundTag nbt) {
        this.pos = tile.getBlockPos();
        this.nbt = nbt;
    }

    public MessageBlockEntitySync(FriendlyByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.nbt = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.pos.getX()).writeInt(this.pos.getY()).writeInt(this.pos.getZ());
        buf.writeNbt((Tag)this.nbt);
    }

    @Override
    public void process(PlayPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            context.workHandler().execute(() -> {
                BlockEntity tile;
                Level world = ((Player)context.player().orElseThrow()).level();
                if (world.isAreaLoaded(this.pos, 1) && (tile = world.getBlockEntity(this.pos)) instanceof IEBaseBlockEntity) {
                    ((IEBaseBlockEntity)tile).receiveMessageFromClient(this.nbt);
                }
            });
        } else {
            context.workHandler().execute(() -> {
                BlockEntity tile;
                Level world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (tile = world.getBlockEntity(this.pos)) instanceof IEBaseBlockEntity) {
                    ((IEBaseBlockEntity)tile).receiveMessageFromServer(this.nbt);
                }
            });
        }
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }
}

