/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.gui.IEContainerMenu;
import blusunrize.immersiveengineering.common.gui.sync.GenericDataSerializers;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageContainerData
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("container_data");
    private final List<Pair<Integer, GenericDataSerializers.DataPair<?>>> synced;

    public MessageContainerData(List<Pair<Integer, GenericDataSerializers.DataPair<?>>> synced) {
        this.synced = synced;
    }

    public MessageContainerData(FriendlyByteBuf buf) {
        this(PacketUtils.readList(buf, pb -> Pair.of((Object)pb.readVarInt(), GenericDataSerializers.read(pb))));
    }

    public void write(FriendlyByteBuf buf) {
        PacketUtils.writeList(buf, this.synced, (pair, b) -> {
            b.writeVarInt(((Integer)pair.getFirst()).intValue());
            ((GenericDataSerializers.DataPair)pair.getSecond()).write((FriendlyByteBuf)b);
        });
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            AbstractContainerMenu currentContainer = ImmersiveEngineering.proxy.getClientPlayer().containerMenu;
            if (currentContainer instanceof IEContainerMenu) {
                IEContainerMenu ieContainer = (IEContainerMenu)currentContainer;
                ieContainer.receiveSync(this.synced);
            }
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

