/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.gui.IScreenMessageReceive;
import blusunrize.immersiveengineering.common.network.IMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageContainerUpdate
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("container_update");
    private int windowId;
    private CompoundTag nbt;

    public MessageContainerUpdate(int windowId, CompoundTag nbt) {
        this.windowId = windowId;
        this.nbt = nbt;
    }

    public MessageContainerUpdate(FriendlyByteBuf buf) {
        this.windowId = buf.readByte();
        this.nbt = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.windowId);
        buf.writeNbt((Tag)this.nbt);
    }

    @Override
    public void process(PlayPayloadContext context) {
        ServerPlayer player = (ServerPlayer)context.player().get();
        assert (player != null);
        context.workHandler().execute(() -> {
            AbstractContainerMenu patt1540$temp;
            player.resetLastActionTime();
            if (player.containerMenu.containerId == this.windowId && (patt1540$temp = player.containerMenu) instanceof IScreenMessageReceive) {
                IScreenMessageReceive ieMenu = (IScreenMessageReceive)patt1540$temp;
                ieMenu.receiveMessageFromScreen(this.nbt);
            }
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

