/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.wooden.WoodenCrateBlockEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.jetbrains.annotations.NotNull;

public class MessageCrateName
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("crate_name");
    private final BlockPos pos;
    private final String name;

    public MessageCrateName(BlockEntity tile, String name) {
        this.pos = tile.getBlockPos();
        this.name = name;
    }

    public MessageCrateName(FriendlyByteBuf buf) {
        this.pos = new BlockPos(buf.readInt(), buf.readInt(), buf.readInt());
        this.name = buf.readUtf();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.pos.getX()).writeInt(this.pos.getY()).writeInt(this.pos.getZ());
        buf.writeUtf(this.name);
    }

    @Override
    public void process(PlayPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            context.workHandler().execute(() -> {
                BlockEntity tile;
                Level world = ((Player)context.player().orElseThrow()).level();
                if (world.isAreaLoaded(this.pos, 1) && (tile = world.getBlockEntity(this.pos)) instanceof WoodenCrateBlockEntity) {
                    WoodenCrateBlockEntity crate = (WoodenCrateBlockEntity)tile;
                    crate.setCustomName((Component)Component.literal((String)this.name));
                }
            });
        }
    }

    @NotNull
    public ResourceLocation id() {
        return ID;
    }
}

