/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.items.IEShieldItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageMagnetEquip
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("magnet_equip");
    private int fetchSlot;

    public MessageMagnetEquip(int fetch) {
        this.fetchSlot = fetch;
    }

    public MessageMagnetEquip(FriendlyByteBuf buf) {
        this.fetchSlot = buf.readInt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.fetchSlot);
    }

    @Override
    public void process(PlayPayloadContext context) {
        Player player = (Player)context.player().orElseThrow();
        assert (player != null);
        context.workHandler().execute(() -> {
            ItemStack held = player.getItemInHand(InteractionHand.OFF_HAND);
            if (this.fetchSlot >= 0) {
                ItemStack s = (ItemStack)player.getInventory().items.get(this.fetchSlot);
                if (!s.isEmpty() && s.getItem() instanceof IEShieldItem && ((IEShieldItem)s.getItem()).getUpgrades(s).getBoolean("magnet")) {
                    ((IEShieldItem)s.getItem()).getUpgrades(s).putInt("prevSlot", this.fetchSlot);
                    player.getInventory().items.set(this.fetchSlot, (Object)held);
                    player.setItemInHand(InteractionHand.OFF_HAND, s);
                }
            } else if (held.getItem() instanceof IEShieldItem && ((IEShieldItem)held.getItem()).getUpgrades(held).getBoolean("magnet")) {
                int prevSlot = ((IEShieldItem)held.getItem()).getUpgrades(held).getInt("prevSlot");
                ItemStack s = (ItemStack)player.getInventory().items.get(prevSlot);
                player.getInventory().items.set(prevSlot, (Object)held);
                player.setItemInHand(InteractionHand.OFF_HAND, s);
                ((IEShieldItem)held.getItem()).getUpgrades(held).remove("prevSlot");
            }
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

