/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.blocks.wooden.ModWorkbenchBlockEntity;
import blusunrize.immersiveengineering.common.gui.MaintenanceKitContainer;
import blusunrize.immersiveengineering.common.network.IMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageMaintenanceKit
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("maintenance_kit");
    EquipmentSlot slot;
    CompoundTag nbt;

    public MessageMaintenanceKit(EquipmentSlot slot, CompoundTag nbt) {
        this.slot = slot;
        this.nbt = nbt;
    }

    public MessageMaintenanceKit(FriendlyByteBuf buf) {
        this.slot = EquipmentSlot.byName((String)buf.readUtf(100));
        this.nbt = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.slot.getName());
        buf.writeNbt((Tag)this.nbt);
    }

    @Override
    public void process(PlayPayloadContext context) {
        Player player = (Player)context.player().orElseThrow();
        context.workHandler().execute(() -> {
            if (player.containerMenu instanceof MaintenanceKitContainer) {
                ModWorkbenchBlockEntity.applyConfigTo(((Slot)player.containerMenu.slots.get(0)).getItem(), this.nbt);
            }
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

