/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.shader.CapabilityShader;
import blusunrize.immersiveengineering.client.render.entity.ShaderMinecartRenderer;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.register.IEDataAttachments;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageMinecartShaderSync
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("minecart_shader_sync");
    private final int entityID;
    private final ItemStack shader;

    public MessageMinecartShaderSync(Entity entity, CapabilityShader.ShaderWrapper wrapper) {
        this.entityID = entity.getId();
        this.shader = wrapper.getShaderItem();
    }

    public MessageMinecartShaderSync(Entity entity) {
        this.entityID = entity.getId();
        this.shader = ItemStack.EMPTY;
    }

    public MessageMinecartShaderSync(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        this.shader = buf.readItem();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeItem(this.shader);
    }

    @Override
    public void process(PlayPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            Level world = ((Player)context.player().orElseThrow()).level();
            context.workHandler().execute(() -> {
                Entity entity = world.getEntity(this.entityID);
                if (!(entity instanceof AbstractMinecart)) {
                    return;
                }
                CapabilityShader.ShaderWrapper cap = (CapabilityShader.ShaderWrapper)entity.getData(IEDataAttachments.MINECART_SHADER);
                if (cap != null) {
                    PacketDistributor.DIMENSION.with((Object)world.dimension()).send(new CustomPacketPayload[]{new MessageMinecartShaderSync(entity, cap)});
                }
            });
        } else {
            context.workHandler().execute(() -> {
                Entity entity;
                Level world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (entity = world.getEntity(this.entityID)) instanceof AbstractMinecart) {
                    ShaderMinecartRenderer.shadedCarts.put(this.entityID, (Object)this.shader);
                }
            });
        }
    }

    public ResourceLocation id() {
        return ID;
    }
}

