/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.multiblocks.TemplateMultiblock;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.PacketUtils;
import blusunrize.immersiveengineering.mixin.accessors.PaletteAccess;
import blusunrize.immersiveengineering.mixin.accessors.TemplateAccess;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.IdMapper;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import net.neoforged.neoforge.registries.GameData;

public class MessageMultiblockSync
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("multiblock_sync");
    private final List<SyncedTemplate> templates;

    public MessageMultiblockSync(List<SyncedTemplate> templatesToSync) {
        this.templates = templatesToSync;
    }

    public MessageMultiblockSync(FriendlyByteBuf buf) {
        this.templates = PacketUtils.readList(buf, SyncedTemplate::new);
    }

    public void write(FriendlyByteBuf buf) {
        PacketUtils.writeList(buf, this.templates, SyncedTemplate::writeTo);
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            for (SyncedTemplate synced : this.templates) {
                StructureTemplate template = new StructureTemplate();
                TemplateAccess access = (TemplateAccess)template;
                access.setSize((Vec3i)synced.size);
                access.getPalettes().add(synced.parts);
                TemplateMultiblock.SYNCED_CLIENT_TEMPLATES.put(synced.name, template);
            }
            ImmersiveEngineering.proxy.resetManual();
        });
    }

    public ResourceLocation id() {
        return ID;
    }

    public static class SyncedTemplate {
        private final BlockPos size;
        private final ResourceLocation name;
        private final StructureTemplate.Palette parts;

        public SyncedTemplate(StructureTemplate template, ResourceLocation name) {
            this.size = new BlockPos(template.getSize());
            this.parts = ((TemplateAccess)template).getPalettes().get(0);
            this.name = name;
        }

        public SyncedTemplate(FriendlyByteBuf buffer) {
            this.size = buffer.readBlockPos();
            this.name = buffer.readResourceLocation();
            this.parts = PaletteAccess.construct(PacketUtils.readList(buffer, SyncedTemplate::readPart));
        }

        public void writeTo(FriendlyByteBuf buffer) {
            buffer.writeBlockPos(this.size);
            buffer.writeResourceLocation(this.name);
            PacketUtils.writeList(buffer, this.parts.blocks(), SyncedTemplate::writePart);
        }

        private static StructureTemplate.StructureBlockInfo readPart(FriendlyByteBuf buffer) {
            IdMapper stateIds = GameData.getBlockStateIDMap();
            BlockState state = (BlockState)stateIds.byId(buffer.readVarInt());
            BlockPos pos = buffer.readBlockPos();
            CompoundTag nbt = buffer.readNbt();
            return new StructureTemplate.StructureBlockInfo(pos, Objects.requireNonNull(state), nbt);
        }

        private static void writePart(StructureTemplate.StructureBlockInfo info, FriendlyByteBuf buffer) {
            IdMapper stateIds = GameData.getBlockStateIDMap();
            buffer.writeVarInt(stateIds.getId((Object)info.state()));
            buffer.writeBlockPos(info.pos());
            buffer.writeNbt((Tag)info.nbt());
        }
    }
}

