/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.ChatUtils;
import blusunrize.immersiveengineering.mixin.accessors.client.ChatComponentAccess;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.GuiMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record MessageNoSpamChat(Component message) implements IMessage
{
    public static final ResourceLocation ID = IEApi.ieLoc("no_spam_chat");

    public MessageNoSpamChat(FriendlyByteBuf buffer) {
        this(buffer.readComponent());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeComponent(this.message);
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            ChatComponent chat = Minecraft.getInstance().gui.getChat();
            ChatComponentAccess chatAccess = (ChatComponentAccess)chat;
            List<GuiMessage> allMessages = chatAccess.getAllMessages();
            allMessages.removeIf(guiMessage -> Objects.equals(guiMessage.signature(), ChatUtils.NO_SPAM_SIGNATURE));
            chatAccess.invokeRefreshTrimmedMessage();
            chat.addMessage(this.message, ChatUtils.NO_SPAM_SIGNATURE, null);
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

