/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.api.wires.WireType;
import blusunrize.immersiveengineering.client.LevelStageRenders;
import blusunrize.immersiveengineering.common.network.IMessage;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;
import org.apache.commons.lang3.mutable.MutableInt;

public class MessageObstructedConnection
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("obstructed_connection");
    private final Vec3 start;
    private final Vec3 end;
    private final BlockPos startB;
    private final BlockPos endB;
    private final Collection<BlockPos> blocking;
    private final WireType wireType;

    public MessageObstructedConnection(Connection conn, Collection<BlockPos> blocking) {
        this.blocking = blocking;
        this.start = conn.getEndAOffset();
        this.end = conn.getEndBOffset();
        this.startB = conn.getEndA().position();
        this.endB = conn.getEndB().position();
        this.wireType = conn.type;
    }

    public MessageObstructedConnection(FriendlyByteBuf buf) {
        this.start = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.end = new Vec3(buf.readDouble(), buf.readDouble(), buf.readDouble());
        this.startB = buf.readBlockPos();
        this.endB = buf.readBlockPos();
        int count = buf.readInt();
        this.blocking = new ArrayList<BlockPos>(count);
        for (int i = 0; i < count; ++i) {
            this.blocking.add(buf.readBlockPos());
        }
        this.wireType = WireType.getValue(buf.readUtf(100));
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeDouble(this.start.x).writeDouble(this.start.y).writeDouble(this.start.z);
        buf.writeDouble(this.end.x).writeDouble(this.end.y).writeDouble(this.end.z);
        buf.writeBlockPos(this.startB);
        buf.writeBlockPos(this.endB);
        buf.writeInt(this.blocking.size());
        for (BlockPos b : this.blocking) {
            buf.writeBlockPos(b);
        }
        buf.writeUtf(this.wireType.getUniqueName());
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Connection conn = new Connection(this.wireType, new ConnectionPoint(this.startB, 0), new ConnectionPoint(this.endB, 0), this.start, this.end);
            LevelStageRenders.FAILED_CONNECTIONS.put(conn, (Pair<Collection<BlockPos>, MutableInt>)Pair.of(this.blocking, (Object)new MutableInt(200)));
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

