/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.GlobalWireNetwork;
import blusunrize.immersiveengineering.client.models.ModelPowerpack;
import blusunrize.immersiveengineering.common.network.IMessage;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessagePowerpackAntenna
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("powerpack_antenna");
    UUID player;
    boolean remove = false;
    BlockPos from;
    BlockPos to;

    public MessagePowerpackAntenna(Player player, @Nullable Connection connection) {
        this.player = player.getUUID();
        if (connection == null) {
            this.remove = true;
        } else {
            this.from = connection.getEndA().position();
            this.to = connection.getEndB().position();
        }
    }

    public MessagePowerpackAntenna(FriendlyByteBuf buf) {
        this.player = buf.readUUID();
        this.remove = buf.readBoolean();
        if (!this.remove) {
            this.from = buf.readBlockPos();
            this.to = buf.readBlockPos();
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUUID(this.player);
        buf.writeBoolean(this.remove);
        if (!this.remove) {
            buf.writeBlockPos(this.from);
            buf.writeBlockPos(this.to);
        }
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null) {
                if (this.remove) {
                    ModelPowerpack.PLAYER_ATTACHED_TO.remove(this.player);
                } else {
                    GlobalWireNetwork global = GlobalWireNetwork.getNetwork(world);
                    global.getLocalNet(this.from).getConnections(this.from).stream().filter(conn -> conn.getEndA().position().equals((Object)this.from) && conn.getEndB().position().equals((Object)this.to) || conn.getEndB().position().equals((Object)this.from) && conn.getEndA().position().equals((Object)this.to)).findFirst().ifPresent(c -> ModelPowerpack.PLAYER_ATTACHED_TO.put(this.player, (Connection)c));
                }
            }
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

