/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.utils.FastEither;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageStoredEnergy;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record MessageRequestEnergyUpdate(FastEither<BlockPos, Integer> pos) implements IMessage
{
    public static final ResourceLocation ID = IEApi.ieLoc("request_energy_update");

    public MessageRequestEnergyUpdate(FriendlyByteBuf buf) {
        this(MessageRequestEnergyUpdate.readPos(buf));
    }

    public void write(FriendlyByteBuf buf) {
        MessageRequestEnergyUpdate.writePos(buf, this.pos);
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Entity entity;
            Level level = ((Player)context.player().orElseThrow()).level();
            Object storage = this.pos.isLeft() ? (IEnergyStorage)level.getCapability(Capabilities.EnergyStorage.BLOCK, this.pos.leftNonnull(), null) : ((entity = level.getEntity(this.pos.rightNonnull().intValue())) != null ? (IEnergyStorage)entity.getCapability(Capabilities.EnergyStorage.ENTITY, null) : null);
            VoltmeterItem.RemoteEnergyData data = null;
            if (storage != null && storage.getMaxEnergyStored() > 0) {
                data = new VoltmeterItem.RemoteEnergyData(this.pos, level.getGameTime(), true, storage.getEnergyStored(), storage.getMaxEnergyStored());
            }
            if (data == null) {
                data = new VoltmeterItem.RemoteEnergyData(this.pos, level.getGameTime(), false, 0, 0);
            }
            PacketDistributor.PLAYER.with((Object)this.serverPlayer(context)).send(new CustomPacketPayload[]{new MessageStoredEnergy(data)});
        });
    }

    public static FastEither<BlockPos, Integer> readPos(FriendlyByteBuf buf) {
        if (buf.readBoolean()) {
            return FastEither.right(buf.readInt());
        }
        return FastEither.left(buf.readBlockPos());
    }

    public static void writePos(FriendlyByteBuf out, FastEither<BlockPos, Integer> pos) {
        out.writeBoolean(pos.isRight());
        if (pos.isRight()) {
            out.writeInt(pos.rightNonnull().intValue());
        } else {
            out.writeBlockPos(pos.leftNonnull());
        }
    }

    public ResourceLocation id() {
        return ID;
    }
}

