/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.items.VoltmeterItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.network.MessageRedstoneLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public record MessageRequestRedstoneUpdate(BlockPos pos) implements IMessage
{
    public static final ResourceLocation ID = IEApi.ieLoc("request_rs_update");

    public MessageRequestRedstoneUpdate(FriendlyByteBuf buf) {
        this(MessageRequestRedstoneUpdate.readPos(buf));
    }

    public void write(FriendlyByteBuf buf) {
        MessageRequestRedstoneUpdate.writePos(buf, this.pos);
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Level level = ((Player)context.player().orElseThrow()).level();
            BlockState blockState = level.getBlockState(this.pos);
            VoltmeterItem.RemoteRedstoneData data = new VoltmeterItem.RemoteRedstoneData(this.pos, level.getGameTime(), blockState.isSignalSource(), MessageRequestRedstoneUpdate.redstoneLevel(level, this.pos));
            PacketDistributor.PLAYER.with((Object)this.serverPlayer(context)).send(new CustomPacketPayload[]{new MessageRedstoneLevel(data)});
        });
    }

    public static byte redstoneLevel(Level level, BlockPos pos) {
        BlockState blockState = level.getBlockState(pos);
        byte redstoneLevel = 0;
        if (blockState != null) {
            if (blockState.isSignalSource()) {
                redstoneLevel = blockState.getOptionalValue((Property)RedStoneWireBlock.POWER).orElse(0).byteValue();
                for (Direction facing : Direction.values()) {
                    redstoneLevel = (byte)Math.max(redstoneLevel, blockState.getSignal((BlockGetter)level, pos, facing));
                }
            } else {
                redstoneLevel = (byte)Math.max(redstoneLevel, level.getDirectSignalTo(pos));
            }
        }
        return redstoneLevel;
    }

    public static BlockPos readPos(FriendlyByteBuf buf) {
        return buf.readBlockPos();
    }

    public static void writePos(FriendlyByteBuf out, BlockPos pos) {
        out.writeBlockPos(pos);
    }

    public ResourceLocation id() {
        return ID;
    }
}

