/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.shader.ShaderRegistry;
import blusunrize.immersiveengineering.api.utils.IngredientUtils;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageShaderManual
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("shader_manual");
    private final MessageType key;
    private final ResourceLocation[] args;

    public MessageShaderManual(MessageType key, ResourceLocation ... args) {
        this.key = key;
        this.args = args;
    }

    public MessageShaderManual(FriendlyByteBuf buf) {
        this.key = MessageType.values()[buf.readInt()];
        int l = buf.readInt();
        this.args = new ResourceLocation[l];
        for (int i = 0; i < l; ++i) {
            this.args[i] = new ResourceLocation(buf.readUtf(1000));
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.key.ordinal());
        buf.writeInt(this.args.length);
        for (ResourceLocation rl : this.args) {
            buf.writeUtf(rl.toString());
        }
    }

    @Override
    public void process(PlayPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            ServerPlayer player = this.serverPlayer(context);
            UUID playerId = player.getUUID();
            context.workHandler().execute(() -> {
                if (this.key == MessageType.SYNC) {
                    ResourceLocation[] ss = (ResourceLocation[])ShaderRegistry.receivedShaders.get((Object)playerId).stream().filter(Objects::nonNull).toArray(ResourceLocation[]::new);
                    PacketDistributor.PLAYER.with((Object)player).send(new CustomPacketPayload[]{new MessageShaderManual(MessageType.SYNC, ss)});
                } else if (this.key == MessageType.UNLOCK && this.args.length > 0) {
                    ShaderRegistry.receivedShaders.put((Object)playerId, (Object)this.args[0]);
                } else if (this.key == MessageType.SPAWN && this.args.length > 0) {
                    if (!player.getAbilities().instabuild) {
                        IngredientUtils.consumePlayerIngredient((Player)player, ShaderRegistry.shaderRegistry.get((Object)this.args[0]).replicationCost.get());
                    }
                    ItemStack shaderStack = new ItemStack((ItemLike)ShaderRegistry.itemShader);
                    ItemNBTHelper.putString(shaderStack, "shader_name", this.args[0].toString());
                    ItemEntity entityitem = player.drop(shaderStack, false);
                    if (entityitem != null) {
                        entityitem.setNoPickUpDelay();
                        entityitem.setThrower((Entity)player);
                    }
                }
            });
        } else {
            context.workHandler().execute(() -> {
                Player player;
                if (this.key == MessageType.SYNC && (player = ImmersiveEngineering.proxy.getClientPlayer()) != null) {
                    UUID name = player.getUUID();
                    for (ResourceLocation shader : this.args) {
                        if (shader == null) continue;
                        ShaderRegistry.receivedShaders.put((Object)name, (Object)shader);
                    }
                }
            });
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static enum MessageType {
        SYNC,
        UNLOCK,
        SPAWN;

    }
}

