/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.wires.Connection;
import blusunrize.immersiveengineering.api.wires.ConnectionPoint;
import blusunrize.immersiveengineering.common.entities.SkylineHookEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageSkyhookSync
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("skyhook_sync");
    private int entityID;
    private Connection connection;
    private ConnectionPoint start;
    private double linePos;
    private double speed;

    public MessageSkyhookSync(SkylineHookEntity entity) {
        this.entityID = entity.getId();
        this.connection = entity.getConnection();
        this.linePos = entity.linePos;
        this.start = entity.start;
        this.speed = entity.horizontalSpeed;
    }

    public MessageSkyhookSync(FriendlyByteBuf buf) {
        this.entityID = buf.readInt();
        CompoundTag tag = buf.readNbt();
        this.connection = new Connection(tag);
        this.linePos = buf.readDouble();
        this.speed = buf.readDouble();
        this.start = new ConnectionPoint(buf.readNbt());
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeNbt((Tag)this.connection.toNBT());
        buf.writeDouble(this.linePos);
        buf.writeDouble(this.speed);
        buf.writeNbt((Tag)this.start.createTag());
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Entity ent;
            Level world = ImmersiveEngineering.proxy.getClientWorld();
            if (world != null && (ent = world.getEntity(this.entityID)) instanceof SkylineHookEntity) {
                SkylineHookEntity hook = (SkylineHookEntity)ent;
                hook.setConnectionAndPos(this.connection, this.start, this.linePos, this.speed);
            }
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

