/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.common.items.RevolverItem;
import blusunrize.immersiveengineering.common.network.IMessage;
import blusunrize.immersiveengineering.common.register.IEItems;
import blusunrize.immersiveengineering.common.util.IESounds;
import blusunrize.immersiveengineering.common.util.ItemNBTHelper;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class MessageSpeedloaderSync
implements IMessage {
    public static final ResourceLocation ID = IEApi.ieLoc("speedloader_sync");
    private final int slot;
    private final InteractionHand hand;

    public MessageSpeedloaderSync(int slot, InteractionHand hand) {
        this.slot = slot;
        this.hand = hand;
    }

    public MessageSpeedloaderSync(FriendlyByteBuf buf) {
        this.slot = buf.readByte();
        this.hand = InteractionHand.values()[buf.readByte()];
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.slot);
        buf.writeByte(this.hand.ordinal());
    }

    @Override
    public void process(PlayPayloadContext context) {
        context.workHandler().execute(() -> {
            Player player = ImmersiveEngineering.proxy.getClientPlayer();
            if (player != null) {
                if (player.getItemInHand(this.hand).getItem() instanceof RevolverItem) {
                    player.playSound((SoundEvent)IESounds.revolverReload.value(), 1.0f, 1.0f);
                    ItemNBTHelper.putInt(player.getItemInHand(this.hand), "reload", 60);
                }
                player.getInventory().setItem(this.slot, new ItemStack(IEItems.Weapons.SPEEDLOADER));
            }
        });
    }

    public ResourceLocation id() {
        return ID;
    }
}

